/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.soap;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.Mapping;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.interceptor.rest.RESTInterceptor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.rules.SOAPProxy;
import com.predic8.wsdl.Binding;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Documentation;
import com.predic8.wsdl.Operation;
import com.predic8.wsdl.Part;
import com.predic8.wsdl.Port;
import com.predic8.wsdl.PortType;
import com.predic8.wsdl.Service;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import com.predic8.wstool.creator.RequestTemplateCreator;
import com.predic8.wstool.creator.SOARequestCreator;
import groovy.xml.MarkupBuilder;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="webServiceExplorer")
public class WebServiceExplorerInterceptor
extends RESTInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)WebServiceExplorerInterceptor.class.getName());
    private String wsdl;
    private String portName;
    private static final Pattern wsdlRequest = Pattern.compile(".*\\?(wsdl|xsd=.*)", 2);
    private volatile Definitions parsedWSDL;

    public WebServiceExplorerInterceptor() {
        this.name = "Web Service Explorer";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().getMethod().equals("GET") && !this.isWSDLRequest(exc.getRequest())) {
            return super.handleRequest(exc);
        }
        return Outcome.CONTINUE;
    }

    private boolean isWSDLRequest(Request request) {
        return wsdlRequest.matcher(request.getUri()).matches();
    }

    public String getWsdl() {
        return this.wsdl;
    }

    @MCAttribute
    @Required
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
        this.parsedWSDL = null;
    }

    public String getPortName() {
        return this.portName;
    }

    @MCAttribute
    public void setPortName(String portName) {
        this.portName = portName;
    }

    private Definitions getParsedWSDL() {
        if (this.parsedWSDL != null) {
            return this.parsedWSDL;
        }
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setInput((Object)ResolverMap.combine(this.router.getBaseLocation(), this.wsdl));
        WSDLParser wsdlParser = new WSDLParser();
        wsdlParser.setResourceResolver((Object)this.router.getResolverMap().toExternalResolver().toExternalResolver());
        this.parsedWSDL = wsdlParser.parse(ctx);
        return this.parsedWSDL;
    }

    @Mapping(value="[^?]*/operation/([^/?]+)/([^/?]+)/([^/?]+)")
    public Response createOperationResponse(QueryParameter params, String relativeRootPath) throws Exception {
        try {
            final String bindingName = params.getGroup(1);
            final String portName = params.getGroup(2);
            final String operationName = params.getGroup(3);
            final Definitions w = this.getParsedWSDL();
            final Service service = this.getService(w);
            StringWriter sw = new StringWriter();
            new StandardPage(sw, null){

                @Override
                protected void createContent() {
                    ((Html)this.h1()).text("Service Proxy for " + service.getName());
                    ((Html)((Html)this.h2()).text("Operation: " + operationName)).end();
                    ((Html)((Html)this.h3()).text("Sample Request")).end();
                    ((Html)((Html)this.pre()).text(WebServiceExplorerInterceptor.this.generateSampleRequest(portName, operationName, bindingName, w))).end();
                }
            };
            return Response.ok(sw.toString()).build();
        }
        catch (IllegalArgumentException e) {
            log.error("", (Throwable)e);
            return Response.internalServerError().build();
        }
    }

    private Service getService(Definitions d) {
        if (d.getServices().size() != 1) {
            throw new IllegalArgumentException("WSDL needs to have exactly one service for SOAPUIInterceptor to work.");
        }
        return (Service)d.getServices().get(0);
    }

    private String getClientURL(Exchange exc) {
        try {
            Object uri = exc.getHandler().getContextPath(exc) + exc.getRequestURI();
            String host = exc.getRequest().getHeader().getHost();
            if (host != null) {
                if (host.contains(":")) {
                    host = host.substring(0, host.indexOf(":"));
                }
                boolean https = exc.getRule().getSslInboundContext() != null;
                uri = new URL(https ? "https" : "http", host, exc.getHandler().getLocalPort(), (String)uri).toString();
            }
            return uri;
        }
        catch (MalformedURLException e) {
            log.debug("Malformed URL", (Throwable)e);
            return exc.getRequest().getUri();
        }
    }

    @Mapping(value="(?!.*operation)([^?]*)")
    public Response createSOAPUIResponse(QueryParameter params, String relativeRootPath, final Exchange exc) throws Exception {
        try {
            final String myPath = this.router.getUriFactory().create(exc.getRequestURI()).getPath();
            final Definitions w = this.getParsedWSDL();
            final Service service = this.getService(w);
            final Port port = SOAPProxy.selectPort(service.getPorts(), this.portName);
            final List<Port> ports = this.getPortsByLocation(service, port);
            StringWriter sw = new StringWriter();
            new StandardPage(sw, service.getName()){

                @Override
                protected void createContent() {
                    ((Html)((Html)this.h1()).text("Service Proxy: " + service.getName())).end();
                    this.p();
                    this.text("Target Namespace: " + w.getTargetNamespace());
                    ((Html)this.br()).end();
                    String wsdlLink = WebServiceExplorerInterceptor.this.getClientURL(exc) + "?wsdl";
                    ((Html)((Html)((Html)((Html)this.text("WSDL: ")).a()).href(wsdlLink)).text(wsdlLink)).end();
                    this.end();
                    for (PortType pt : w.getPortTypes()) {
                        ((Html)((Html)this.h2()).text("Port Type: " + pt.getName())).end();
                        Documentation d = pt.getDocumentation();
                        if (d == null) continue;
                        ((Html)((Html)this.p()).text("Documentation: " + d.toString())).end();
                    }
                    Binding binding = port.getBinding();
                    PortType portType = binding.getPortType();
                    List<Operation> bindingOperations = WebServiceExplorerInterceptor.this.getOperationsByBinding(w, binding);
                    if (bindingOperations.isEmpty()) {
                        ((Html)((Html)this.p()).text("There are no operations defined.")).end();
                    } else {
                        this.createOperationsTable(w, bindingOperations, binding, portType);
                    }
                    ((Html)((Html)this.h2()).text("Virtual Endpoint")).end();
                    ((Html)((Html)((Html)((Html)((Html)this.p()).a()).href(WebServiceExplorerInterceptor.this.getClientURL(exc))).text(WebServiceExplorerInterceptor.this.getClientURL(exc))).end()).end();
                    ((Html)((Html)this.h2()).text("Target Endpoints")).end();
                    if (service.getPorts().isEmpty()) {
                        ((Html)((Html)this.p()).text("There are no endpoints defined.")).end();
                    } else {
                        this.createEndpointTable(service.getPorts(), ports);
                    }
                }

                private void createOperationsTable(Definitions w2, List<Operation> bindingOperations, Binding binding, PortType portType) {
                    ((Html)((Html)((Html)this.table()).cellspacing("0")).cellpadding("0")).border("1");
                    this.tr();
                    ((Html)((Html)this.th()).text("Operation")).end();
                    ((Html)((Html)this.th()).text("Input")).end();
                    ((Html)((Html)this.th()).text("Output")).end();
                    this.end();
                    for (Operation o : bindingOperations) {
                        this.tr();
                        this.td();
                        if ("HTTP".equals(WebServiceExplorerInterceptor.this.getProtocolVersion(binding))) {
                            this.text(o.getName());
                        } else {
                            String link = myPath + "/operation/" + binding.getName() + "/" + portType.getName() + "/" + o.getName();
                            ((Html)((Html)((Html)this.a()).href(link)).text(o.getName())).end();
                        }
                        this.end();
                        this.td();
                        for (Part p : o.getInput().getMessage().getParts()) {
                            this.text(p.getElement().getName());
                        }
                        this.end();
                        this.td();
                        for (Part p : o.getOutput().getMessage().getParts()) {
                            this.text(p.getElement().getName());
                        }
                        this.end();
                        this.end();
                    }
                    this.end();
                }

                private void createEndpointTable(List<Port> ports2, List<Port> matchingPorts) {
                    ((Html)((Html)((Html)this.table()).cellspacing("0")).cellpadding("0")).border("1");
                    this.tr();
                    ((Html)((Html)this.th()).text("Port Name")).end();
                    ((Html)((Html)this.th()).text("Protocol")).end();
                    ((Html)((Html)this.th()).text("URL")).end();
                    this.end();
                    for (Port p : ports2) {
                        this.tr();
                        ((Html)((Html)this.td()).text(p.getName())).end();
                        ((Html)((Html)this.td()).text(WebServiceExplorerInterceptor.this.getProtocolVersion(p.getBinding()))).end();
                        ((Html)((Html)this.td()).text(p.getAddress().getLocation())).end();
                        this.td();
                        if (matchingPorts.contains(p)) {
                            this.text("*");
                        }
                        this.end();
                        this.end();
                    }
                    this.end();
                    ((Html)((Html)((Html)((Html)this.p()).small()).text("* available through this proxy")).end()).end();
                }
            };
            return Response.ok(sw.toString()).build();
        }
        catch (IllegalArgumentException e) {
            log.error("", (Throwable)e);
            return Response.internalServerError().build();
        }
    }

    private List<Operation> getOperationsByBinding(Definitions w, Binding binding) {
        ArrayList<Operation> bindingOperations = new ArrayList<Operation>();
        for (Operation o : w.getOperations()) {
            if (binding.getOperation(o.getName()) == null) continue;
            bindingOperations.add(o);
        }
        return bindingOperations;
    }

    private List<Port> getPortsByLocation(Service service, Port port) {
        String location = port.getAddress().getLocation();
        if (location == null) {
            throw new IllegalArgumentException("Location not set for port in WSDL.");
        }
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : service.getPorts()) {
            if (!location.equals(p.getAddress().getLocation())) continue;
            ports.add(p);
        }
        return ports;
    }

    private String getProtocolVersion(Binding binding) {
        String transport = ((QName)binding.getBinding().getElementName()).getNamespaceURI();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(transport)) {
            transport = "SOAP 1.1";
        }
        if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(transport)) {
            transport = "SOAP 1.2";
        }
        if ("http://schemas.xmlsoap.org/wsdl/http/".equals(transport)) {
            transport = "HTTP";
        }
        return transport;
    }

    private String generateSampleRequest(String portName, String operationName, String bindingName, Definitions w) {
        StringWriter writer = new StringWriter();
        SOARequestCreator creator = new SOARequestCreator(w, (Object)new RequestTemplateCreator(), new MarkupBuilder((Writer)writer));
        creator.createRequest(portName, operationName, bindingName);
        return writer.toString();
    }

    @Override
    public String getShortDescription() {
        return "Displays a graphical UI describing the web service when accessed using GET requests.";
    }

    private abstract class StandardPage
    extends Html {
        public StandardPage(Writer writer, String title) {
            super(writer);
            this.html();
            this.head();
            ((Html)((Html)this.title()).text("Membrane Service Proxy" + (String)(title == null ? "" : ": " + title))).end();
            this.style();
            this.raw("<!--\r\nbody { font-family: sans-serif; }\r\nh1 { font-size: 24pt; }\r\nh2 { font-size: 16pt; }\r\nh3 { font-size: 12pt; }\r\ntd, th { border: 1px solid black; padding: 0pt 10pt; }\r\ntable { border-collapse: collapse; }\r\n.help { margin-top:20pt; color:#AAAAAA; padding:1em 0em 0em 0em; font-size:10pt; }\r\n.footer { color:#AAAAAA; padding:0em 0em; font-size:10pt; }\r\n.footer a { color:#AAAAAA; }\r\n.footer a:hover { color:#000000; }\r\n-->");
            this.end();
            this.end();
            this.body();
            this.createContent();
            ((Html)((Html)((Html)this.p()).classAttr("footer")).raw("Copyright \u00a92009-2022 <a href=\"http://predic8.com/\">predic8 GmbH</a>. All Rights Reserved. See <a href=\"http://www.membrane-soa.org/service-proxy/\">http://www.membrane-soa.org/service-proxy/</a> for documentation and updates.")).end();
            this.end();
            this.end();
        }

        protected abstract void createContent();
    }
}

