/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.statistics;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="statisticsProvider")
public class StatisticsProvider
extends AbstractInterceptor
implements ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger((String)StatisticsProvider.class.getName());
    private final JsonFactory jsonFactory = new JsonFactory();
    private DataSource dataSource;
    private String dataSourceBeanId;
    private ApplicationContext applicationContext;
    private static final ImmutableMap<String, String> sortNameColmnMapping = new ImmutableMap.Builder().put((Object)"statusCode", (Object)"status_code").put((Object)"time", (Object)"time").build();

    public StatisticsProvider() {
        this.name = "Provides caller statistics as JSON";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Connection con = this.dataSource.getConnection();
        try {
            int offset = URLParamUtil.getIntParam(this.router.getUriFactory(), exc, "offset");
            int max = URLParamUtil.getIntParam(this.router.getUriFactory(), exc, "max");
            int total = this.getTotal(con);
            Statement s = con.createStatement(1004, 1007);
            ResultSet r = s.executeQuery(StatisticsProvider.getOrderedStatistics(this.router.getUriFactory(), exc));
            this.createJson(exc, r, offset, max, total);
        }
        catch (Exception e) {
            log.warn("Could not retrieve statistics.", (Throwable)e);
            Outcome outcome = Outcome.ABORT;
            return outcome;
        }
        finally {
            this.closeConnection(con);
        }
        return Outcome.RETURN;
    }

    public static String getOrderedStatistics(URIFactory uriFactory, Exchange exc) throws Exception {
        String iOrder = URLParamUtil.getStringParam(uriFactory, exc, "order");
        String iSort = URLParamUtil.getStringParam(uriFactory, exc, "sort");
        String order = "desc".equals(iOrder.toLowerCase()) ? "desc" : "asc";
        String sort = !sortNameColmnMapping.containsKey((Object)iSort) ? "id" : (String)sortNameColmnMapping.get((Object)iSort);
        return "select * from statistic ORDER BY " + sort + " " + order;
    }

    private int getTotal(Connection con) throws Exception {
        ResultSet r = con.createStatement().executeQuery("select count(*) from statistic");
        r.next();
        return r.getInt(1);
    }

    private void createResponse(Exchange exc, StringWriter jsonTxt) {
        exc.setResponse(Response.ok().body(jsonTxt.toString()).build());
    }

    private void createJson(Exchange exc, ResultSet r, int offset, int max, int total) throws IOException, JsonGenerationException, SQLException {
        StringWriter jsonTxt = new StringWriter();
        JsonGenerator jsonGen = this.jsonFactory.createGenerator((Writer)jsonTxt);
        jsonGen.writeStartObject();
        jsonGen.writeArrayFieldStart("statistics");
        r.absolute(offset + 1);
        for (int size = 0; size < max && !r.isAfterLast(); ++size) {
            this.writeRecord(r, jsonGen);
            r.next();
        }
        jsonGen.writeEndArray();
        jsonGen.writeNumberField("total", total);
        jsonGen.writeEndObject();
        jsonGen.flush();
        this.createResponse(exc, jsonTxt);
    }

    private void writeRecord(ResultSet r, JsonGenerator jsonGen) throws IOException, JsonGenerationException, SQLException {
        jsonGen.writeStartObject();
        jsonGen.writeNumberField("statusCode", r.getInt("status_code"));
        jsonGen.writeStringField("time", r.getString("time"));
        jsonGen.writeStringField("rule", r.getString("rule"));
        jsonGen.writeStringField("method", r.getString("method"));
        jsonGen.writeStringField("path", r.getString("path"));
        jsonGen.writeStringField("client", r.getString("client"));
        jsonGen.writeStringField("server", r.getString("server"));
        jsonGen.writeStringField("reqContentType", r.getString("req_content_type"));
        jsonGen.writeNumberField("reqContentLenght", r.getInt("req_content_length"));
        jsonGen.writeStringField("respContentType", r.getString("resp_content_type"));
        jsonGen.writeNumberField("respContentLenght", r.getInt("resp_content_length"));
        jsonGen.writeNumberField("duration", r.getInt("duration"));
        jsonGen.writeStringField("msgFilePath", r.getString("msgfilepath"));
        jsonGen.writeEndObject();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @MCAttribute(attributeName="dataSourceBeanId")
    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceBeanId() {
        return this.dataSourceBeanId;
    }

    @Deprecated
    public void setDataSourceBeanId(String dataSourceBeanId) {
        this.dataSourceBeanId = dataSourceBeanId;
    }

    @Override
    public void init() throws Exception {
        if (this.dataSourceBeanId != null) {
            this.dataSource = (DataSource)this.applicationContext.getBean(this.dataSourceBeanId, DataSource.class);
        }
    }

    private void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            log.warn("Could not close JDBC connection", (Throwable)e);
        }
    }
}

