/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.statistics.util;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangesUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;

public class JDBCUtil {
    public static final String SEQUENCE_STATISTIC = "stat_seq";
    public static final String TRIGGER_STATISTIC = "stat_seq_trigger";
    public static final String TABLE_NAME = "statistic";
    public static final String ID = "id";
    public static final String STATUS_CODE = "status_code";
    public static final String TIME = "time";
    public static final String RULE = "rule";
    public static final String METHOD = "method";
    public static final String PATH = "path";
    public static final String CLIENT = "client";
    public static final String SERVER = "server";
    public static final String REQUEST_CONTENT_TYPE = "req_content_type";
    public static final String REQUEST_CONTENT_LENGTH = "req_content_length";
    public static final String RESPONSE_CONTENT_TYPE = "resp_content_type";
    public static final String RESPONSE_CONTENT_LENGTH = "resp_content_length";
    public static final String DURATION = "duration";
    public static final String MSG_FILE_PATH = "msgfilepath";
    public static final String CREATE_SEQUENCE = "CREATE SEQUENCE stat_seq";
    public static final String CREATE_TRIGGER = "CREATE TRIGGER stat_seq_trigger BEFORE INSERT ON statistic FOR EACH ROW BEGIN IF (:new.id IS NULL) THEN SELECT stat_seq.nextval INTO :new.id FROM DUAL; END IF; END; ";
    public static final String COUNT_ALL = "select count(*) from statistic";

    public static String getCreateTableStatementForOracle() {
        return JDBCUtil.getCreateTableStatement("id INT PRIMARY KEY");
    }

    public static String getCreateTableStatementForMySQL() {
        return JDBCUtil.getCreateTableStatement("id INT NOT NULL AUTO_INCREMENT PRIMARY KEY");
    }

    public static String getCreateTableStatementForDerby() {
        return JDBCUtil.getCreateTableStatement("id INT GENERATED ALWAYS AS IDENTITY");
    }

    public static String getCreateTableStatementForOther() {
        return JDBCUtil.getCreateTableStatement("id BIGINT NOT NULL PRIMARY KEY");
    }

    public static String getCreateTableStatement(String idPart) {
        return "CREATE TABLE statistic ( " + idPart + ", status_code INT, time VARCHAR(155), rule VARCHAR(255), method VARCHAR(50), path VARCHAR(1000), client VARCHAR(255), server VARCHAR(255), req_content_type VARCHAR(100), req_content_length BIGINT, resp_content_type VARCHAR(100), resp_content_length BIGINT, duration INT, msgfilepath VARCHAR(255) )";
    }

    public static String getPreparedInsertStatement(boolean idGenerated) {
        return "INSERT INTO statistic ( " + JDBCUtil.getPreparedInsertIntro(idGenerated) + "status_code,time,rule,method,path,client,server,req_content_type,req_content_length,resp_content_type,resp_content_length,duration,msgfilepath) " + JDBCUtil.getPreparedInsertProlog(idGenerated);
    }

    private static String getPreparedInsertIntro(boolean idGenerated) {
        if (idGenerated) {
            return "";
        }
        return "id,";
    }

    private static String getPreparedInsertProlog(boolean idGenerated) {
        String head = "VALUES(";
        String tail = "?,?,?,?,?,?,?,?,?,?,?,?,?)";
        if (idGenerated) {
            return head + tail;
        }
        return head + "?," + tail;
    }

    public static boolean isIdGenerated(DatabaseMetaData metaData) throws Exception {
        return JDBCUtil.isDerbyDatabase(metaData) || JDBCUtil.isMySQLDatabase(metaData) || JDBCUtil.isOracleDatabase(metaData);
    }

    public static void setData(AbstractExchange exc, PreparedStatement prepSt, boolean idGenerated) throws SQLException {
        int startIndex = 0;
        if (!idGenerated) {
            UUID id = UUID.randomUUID();
            prepSt.setLong(++startIndex, id.getLeastSignificantBits());
        }
        prepSt.setInt(++startIndex, exc.getResponse().getStatusCode());
        prepSt.setString(++startIndex, ExchangesUtil.getTime(exc));
        prepSt.setString(++startIndex, exc.getRule().toString());
        prepSt.setString(++startIndex, exc.getRequest().getMethod());
        prepSt.setString(++startIndex, exc.getRequest().getUri());
        prepSt.setString(++startIndex, exc.getRemoteAddr());
        prepSt.setString(++startIndex, exc.getServer());
        prepSt.setString(++startIndex, exc.getRequestContentType());
        prepSt.setLong(++startIndex, exc.getRequestContentLength());
        prepSt.setString(++startIndex, exc.getResponseContentType());
        prepSt.setLong(++startIndex, exc.getResponseContentLength());
        prepSt.setLong(++startIndex, exc.getTimeResReceived() - exc.getTimeReqSent());
        prepSt.setString(++startIndex, JDBCUtil.getFilePath(exc));
    }

    public static String getFilePath(AbstractExchange exc) {
        if (exc.getProperty("message.file.path") != null) {
            return (String)exc.getProperty("message.file.path");
        }
        return "";
    }

    public static boolean isOracleDatabase(DatabaseMetaData metaData) throws SQLException {
        return Pattern.matches(".*oracle.*", metaData.getDatabaseProductName().toLowerCase());
    }

    public static boolean isMySQLDatabase(DatabaseMetaData metaData) throws SQLException {
        return Pattern.matches(".*mysql.*", metaData.getDatabaseProductName().toLowerCase());
    }

    public static boolean isDerbyDatabase(DatabaseMetaData metaData) throws SQLException {
        return Pattern.matches(".*derby.*", metaData.getDatabaseProductName().toLowerCase());
    }

    public static boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData meta = con.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = meta.getTables("", null, "%", types);
        TreeSet<String> tables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        while (rs.next()) {
            tables.add(rs.getString(3));
        }
        return tables.contains(table);
    }
}

