/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.stomp;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.ConnectionManager;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.ConnectionConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;

@MCElement(name="stompClient")
public class STOMPClient
extends AbstractInterceptor {
    private int port = 61613;
    private String host = null;
    private ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
    private SSLParser sslOutboundParser;
    private ConnectionManager connectionManager;
    private SSLProvider sslOutboundProvider;

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    @Required
    public void setHost(String host) {
        this.host = host;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    @MCChildElement(order=1)
    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public SSLParser getSslOutboundParser() {
        return this.sslOutboundParser;
    }

    @MCChildElement(allowForeign=true, order=2)
    public void setSslOutboundParser(SSLParser sslParser) {
        this.sslOutboundParser = sslParser;
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.connectionManager = new ConnectionManager(this.connectionConfiguration.getKeepAliveTimeout(), router.getTimerManager());
        if (this.sslOutboundParser != null) {
            this.sslOutboundProvider = new StaticSSLContext(this.sslOutboundParser, router.getResolverMap(), router.getBaseLocation());
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        boolean isStomp1_1orAbove;
        String login = exc.getRequest().getHeader().getFirstValue("login");
        String passcode = exc.getRequest().getHeader().getFirstValue("passcode");
        String host = exc.getRequest().getHeader().getFirstValue("host");
        String acceptVersion = exc.getRequest().getHeader().getFirstValue("accept-version");
        boolean isStomp1_0 = login != null && passcode != null;
        boolean bl = isStomp1_1orAbove = host != null && acceptVersion != null;
        if (isStomp1_0 || isStomp1_1orAbove) {
            Connection c = this.connectionManager.getConnection(this.host, this.port, this.connectionConfiguration.getLocalAddr(), this.sslOutboundProvider, this.connectionConfiguration.getTimeout());
            exc.getRequest().writeSTOMP(c.out, false);
            HttpClient.setupConnectionForwarding(exc, c, "STOMP", this.getRouter().getStatistics().getStreamPumpStats());
        } else {
            exc.setResponse(Response.badRequest().build());
        }
        return Outcome.RETURN;
    }
}

