/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.swagger;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.interceptor.swagger.SwaggerCompatibleOpenAPI;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.servers.Server;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenAPIAdapter
implements SwaggerCompatibleOpenAPI {
    final OpenAPI api;

    public OpenAPIAdapter(OpenAPI api) {
        this.api = api;
    }

    @Override
    public String getHost() {
        Optional server = null;
        server = this.api.getServers().stream().findFirst();
        if (!server.isPresent()) {
            throw new RuntimeException("server not set");
        }
        Matcher hostMatcher = Pattern.compile("://(.*?)/").matcher(((Server)server.get()).getUrl());
        if (hostMatcher.find()) {
            return hostMatcher.group(1);
        }
        return "";
    }

    @Override
    public String getBasePath() {
        Optional server = this.api.getServers().stream().findFirst();
        if (!server.isPresent()) {
            throw new RuntimeException("server not set");
        }
        Matcher hostMatcher = Pattern.compile("(.*?://(.*?))?(/.*)").matcher(((Server)server.get()).getUrl());
        if (hostMatcher.find()) {
            return hostMatcher.group(3);
        }
        throw new RuntimeException("not implemented");
    }

    @Override
    public Paths getPaths() {
        return this.api.getPaths();
    }

    @Override
    public byte[] toJSON() throws UnsupportedEncodingException {
        return Json.pretty((Object)this.api).getBytes("UTF-8");
    }

    @Override
    public void setHost(String newHost) {
        Server server = new Server();
        server.setUrl("http://" + newHost);
        this.api.setServers((List)Lists.newArrayList((Object[])new Server[]{server}));
    }

    @Override
    public boolean isNull() {
        return this.api == null;
    }
}

