/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.swagger;

import com.predic8.membrane.core.interceptor.swagger.SwaggerCompatibleOpenAPI;
import io.swagger.models.Path;
import io.swagger.models.RefPath;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.converter.SwaggerConverter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SwaggerAdapter
implements SwaggerCompatibleOpenAPI {
    final Swagger api;

    public SwaggerAdapter(Swagger api) {
        this.api = api;
    }

    @Override
    public String getHost() {
        return this.api.getHost();
    }

    @Override
    public String getBasePath() {
        return this.api.getBasePath();
    }

    @Override
    public Paths getPaths() {
        Paths v3Paths = new Paths();
        Map pathMap = Optional.ofNullable(this.api.getPaths()).orElse(new HashMap());
        for (String pathname : pathMap.keySet()) {
            Path v2Path = this.api.getPath(pathname);
            try {
                SwaggerConverter swaggerConverter = new SwaggerConverter();
                PathItem v3Path = swaggerConverter.convert(v2Path);
                v3Paths.put((Object)pathname, (Object)v3Path);
            }
            catch (Exception exception) {}
        }
        return v3Paths;
    }

    public PathItem convert(Path v2Path) {
        PathItem v3Path = new PathItem();
        if (v2Path instanceof RefPath) {
            v3Path.set$ref(((RefPath)v2Path).get$ref());
        }
        return v3Path;
    }

    @Override
    public byte[] toJSON() throws UnsupportedEncodingException {
        return Json.pretty((Object)this.api).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void setHost(String newHost) {
        this.api.setHost(newHost);
    }

    @Override
    public boolean isNull() {
        return this.api == null;
    }
}

