/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.swagger;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.swagger.OpenAPIAdapter;
import com.predic8.membrane.core.interceptor.swagger.SwaggerAdapter;
import com.predic8.membrane.core.interceptor.swagger.SwaggerCompatibleOpenAPI;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.rules.SwaggerProxy;
import io.swagger.parser.SwaggerParser;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

@MCElement(name="swaggerRewriter")
public class SwaggerRewriterInterceptor
extends AbstractInterceptor {
    private SwaggerCompatibleOpenAPI swagger;
    private boolean rewriteUI = true;
    private String swaggerUrl;
    private String swaggerJson = "swagger.json";

    public SwaggerRewriterInterceptor() {
        this(null, true, "swagger.json");
    }

    public SwaggerRewriterInterceptor(SwaggerCompatibleOpenAPI swag) {
        this(swag, true, "swagger.json");
    }

    public SwaggerRewriterInterceptor(SwaggerCompatibleOpenAPI swag, boolean rewrite) {
        this(swag, rewrite, "swagger.json");
    }

    public SwaggerRewriterInterceptor(SwaggerCompatibleOpenAPI swag, boolean rewrite, String json) {
        this.name = "Swagger Rewriter";
        this.swagger = swag;
        this.rewriteUI = rewrite;
        this.swaggerJson = json;
    }

    public SwaggerRewriterInterceptor(SwaggerCompatibleOpenAPI swag, String swagUrl) {
        this(swag);
        this.swaggerUrl = swagUrl;
    }

    @Override
    public void init() throws Exception {
        Rule parent;
        if ((this.swagger == null || this.swagger.isNull()) && (parent = this.router.getParentProxy(this)) instanceof SwaggerProxy) {
            this.setSwagger(((SwaggerProxy)parent).getSwagger());
        }
        if (this.swagger == null || this.swagger.isNull()) {
            String swaggerSource = IOUtils.toString((InputStream)this.getRouter().getResolverMap().resolve(this.swaggerJson));
            this.swagger = new OpenAPIAdapter(new OpenAPIV3Parser().readContents(swaggerSource).getOpenAPI());
            if (this.swagger == null || this.swagger.isNull()) {
                this.swagger = new SwaggerAdapter(new SwaggerParser().parse(swaggerSource));
                if (this.swagger == null || this.swagger.isNull()) {
                    throw new Exception("couldn't parse Swagger definition");
                }
            }
            this.swaggerUrl = this.swaggerJson;
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        ((ServiceProxy)exc.getRule()).setTargetHost(this.swagger.getHost());
        URL url = new URL(this.swaggerUrl);
        exc.getDestinations().set(0, url.getProtocol() + "://" + url.getHost() + (String)(url.getPort() < 0 ? "" : ":" + url.getPort()) + exc.getOriginalRequestUri());
        return super.handleRequest(exc);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (exc.getRequest().getUri().endsWith(this.swaggerJson) && exc.getResponseContentType().equalsIgnoreCase("application/json")) {
            SwaggerCompatibleOpenAPI swagBody = new OpenAPIAdapter(new OpenAPIV3Parser().readContents(exc.getResponse().getBodyAsStringDecoded()).getOpenAPI());
            if (swagBody == null || swagBody.isNull()) {
                swagBody = new SwaggerAdapter(new SwaggerParser().parse(exc.getResponse().getBodyAsStringDecoded()));
            }
            swagBody.setHost(this.exc2originalHostPort(exc));
            exc.getResponse().setBodyContent(swagBody.toJSON());
        }
        if (this.rewriteUI && (exc.getRequest().getUri().matches("/.*.js(on)?") || exc.getResponse().getHeader().getContentType() != null && exc.getResponse().getHeader().getContentType().equals("text/html"))) {
            String from = "(http(s)?://)" + Pattern.quote(((ServiceProxy)exc.getRule()).getTarget().getHost()) + "(/.*\\.js(on)?)";
            String to = "http" + (this.isTLS(exc) ? "s" : "") + "://" + this.exc2originalHostPort(exc) + "$3";
            byte[] body = exc.getResponse().getBodyAsStringDecoded().replaceAll(from, to).getBytes(exc.getResponse().getCharset());
            exc.getResponse().setBodyContent(body);
        }
        return super.handleResponse(exc);
    }

    private boolean isTLS(Exchange exc) {
        return exc.getRule().getSslInboundContext() != null;
    }

    private String exc2originalHostPort(Exchange exc) {
        return exc.getOriginalHostHeader();
    }

    @Override
    public String getShortDescription() {
        String uipath = "http://" + this.swagger.getHost();
        String jsonpath = "http://" + this.swagger.getHost() + this.swagger.getBasePath() + "/" + this.swaggerJson;
        return "Rewriting <b>" + this.swagger.getHost() + "</b><br/>Allow and Rewrite UI = " + this.rewriteUI + "<br/>" + (String)(this.rewriteUI ? "Swagger UI: <a target='_blank' href='" + uipath + "'>" + uipath + "</a><br/>" : "") + "JSON Specification: <a target='_blank' href='" + jsonpath + "'>" + jsonpath + "</a><br/>";
    }

    public SwaggerCompatibleOpenAPI getSwagger() {
        return this.swagger;
    }

    public void setSwagger(SwaggerCompatibleOpenAPI swagger) {
        this.swagger = swagger;
    }

    public boolean isRewriteUI() {
        return this.rewriteUI;
    }

    @MCAttribute
    public void setRewriteUI(boolean rewriteUI) {
        this.rewriteUI = rewriteUI;
    }

    public String getSwaggerJson() {
        return this.swaggerJson;
    }

    @MCAttribute
    public void setSwaggerJson(String swaggerJson) {
        this.swaggerJson = swaggerJson;
    }
}

