/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.templating;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.beautifier.JSONBeautifier;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.resolver.ResolverMap;
import groovy.text.StreamingTemplateEngine;
import groovy.text.Template;
import groovy.text.XmlTemplateEngine;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@MCElement(name="template", mixed=true)
public class TemplateInterceptor
extends AbstractInterceptor {
    private String location;
    private String textTemplate;
    private Template template;
    private String contentType = "text/plain";
    private Boolean pretty = false;
    private JSONBeautifier jsonBeautifier = new JSONBeautifier();

    public TemplateInterceptor() {
        this.name = "Template";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.handleInternal(exc.getRequest(), exc);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.handleInternal(exc.getResponse(), exc);
        return Outcome.CONTINUE;
    }

    private void handleInternal(Message msg, Exchange exc) {
        msg.getHeader().setContentType(this.getContentType());
        msg.setBodyContent(this.fillAndGetBytes(exc));
    }

    private String prettifyJson(String text) {
        try {
            return this.jsonBeautifier.beautify(text);
        }
        catch (IOException e) {
            return text;
        }
    }

    private String fillTemplate(Exchange exc) {
        String payload = this.template.make(exc.getProperties()).toString();
        if (this.contentType.equals("application/json") && this.pretty.booleanValue()) {
            return this.prettifyJson(payload);
        }
        return payload;
    }

    private byte[] fillAndGetBytes(Exchange exc) {
        return this.fillTemplate(exc).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void init() throws Exception {
        if (this.getLocation() != null && !StringUtils.isBlank((CharSequence)this.getTextTemplate())) {
            throw new IllegalStateException("On <" + this.getName() + ">, ./text() and ./@location cannot be set at the same time.");
        }
        if (this.location != null) {
            try (InputStreamReader reader = new InputStreamReader(this.getRouter().getResolverMap().resolve(ResolverMap.combine(this.router.getBaseLocation(), this.location)));){
                if (FilenameUtils.getExtension((String)this.getLocation()).equals("xml")) {
                    this.template = new XmlTemplateEngine().createTemplate((Reader)reader);
                    this.setContentType("application/xml");
                } else {
                    this.template = new StreamingTemplateEngine().createTemplate((Reader)reader);
                }
                return;
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.textTemplate)) {
            this.template = new StreamingTemplateEngine().createTemplate(this.getTextTemplate());
            return;
        }
        throw new IllegalStateException("You have to set either ./@location or ./text()");
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    public String getTextTemplate() {
        return this.textTemplate;
    }

    @MCTextContent
    public void setTextTemplate(String textTemplate) throws IOException, ClassNotFoundException {
        this.textTemplate = textTemplate;
        if (textTemplate != null && !StringUtils.isBlank((CharSequence)textTemplate)) {
            this.template = new StreamingTemplateEngine().createTemplate(this.getTextTemplate());
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    private String getName() {
        return this.getClass().getAnnotation(MCElement.class).name();
    }

    public String getContentType() {
        return this.contentType;
    }

    @MCAttribute
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getPretty() {
        return this.pretty;
    }

    @MCAttribute
    public void setPretty(String pretty) {
        this.pretty = Boolean.valueOf(pretty);
    }

    private String formatAsHtml(String plaintext) {
        return String.join((CharSequence)"<br />", StringEscapeUtils.escapeHtml4((String)plaintext).split("\n"));
    }

    @Override
    public String getShortDescription() {
        return this.formatAsHtml(this.textTemplate);
    }
}

