/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.tunnel;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.ws.WebSocketInterceptorInterface;
import com.predic8.membrane.core.util.URLUtil;
import java.util.ArrayList;
import java.util.List;

@MCElement(name="webSocket")
public class WebSocketInterceptor
extends AbstractInterceptor {
    private String url;
    private String pathQuery;
    private List<WebSocketInterceptorInterface> interceptors = new ArrayList<WebSocketInterceptorInterface>();

    @Override
    public void init(Router router) throws Exception {
        this.name = "Websocket interceptor";
        this.router = router;
    }

    @Override
    public void init() throws Exception {
        this.pathQuery = this.url == null ? null : URLUtil.getPathQuery(this.getRouter().getUriFactory(), this.url);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if ("websocket".equalsIgnoreCase(exc.getRequest().getHeader().getFirstValue("Upgrade"))) {
            exc.setProperty("use-websocket", Boolean.TRUE);
            if (this.url != null) {
                exc.getRequest().setUri(this.pathQuery);
                exc.getDestinations().set(0, this.url);
            }
        }
        return Outcome.CONTINUE;
    }

    @Override
    public String getShortDescription() {
        return "Allow HTTP protocol upgrades to the <a href=\"http://tools.ietf.org/html/rfc6455\">WebSocket protocol</a>. After the upgrade, the connection's data packets are simply forwarded and not inspected.";
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public List<WebSocketInterceptorInterface> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement
    public void setInterceptors(List<WebSocketInterceptorInterface> interceptors) {
        this.interceptors = interceptors;
    }
}

