/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xml;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.XML;

@MCElement(name="json2Xml")
public class Json2XmlInterceptor
extends AbstractInterceptor {
    private static final String ROOT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleInternal(exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleInternal(exc.getResponse());
    }

    private Outcome handleInternal(Message msg) {
        if (!msg.isJSON()) {
            return Outcome.CONTINUE;
        }
        msg.getHeader().setContentType("text/xml");
        msg.setBodyContent(this.json2Xml(msg.getBodyAsStream()));
        return Outcome.CONTINUE;
    }

    private byte[] json2Xml(InputStream body) {
        return (ROOT + XML.toString((Object)this.convertToJsonObject(body))).getBytes(StandardCharsets.UTF_8);
    }

    private JSONObject convertToJsonObject(InputStream body) {
        return new JSONObject(new JSONTokener((Reader)new InputStreamReader(body, StandardCharsets.UTF_8)));
    }
}

