/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xml;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.XML;
import org.w3c.dom.Document;

@MCElement(name="xml2Json")
public class Xml2JsonInterceptor
extends AbstractInterceptor {
    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleInternal(exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleInternal(exc.getResponse());
    }

    private Outcome handleInternal(Message msg) throws Exception {
        if (!msg.isXML()) {
            return Outcome.CONTINUE;
        }
        if (msg.getHeader().getContentEncoding() != null) {
            msg.setBodyContent(this.xml2json(msg.getBodyAsStreamDecoded(), msg.getHeader().getContentEncoding()));
        } else {
            msg.setBodyContent(this.xml2json(Xml2JsonInterceptor.loadXMLFromStream(msg.getBodyAsStreamDecoded())));
        }
        msg.getHeader().setContentType("application/json;charset=utf-8");
        return Outcome.CONTINUE;
    }

    private byte[] xml2json(InputStream body, String encoding) throws UnsupportedEncodingException {
        return XML.toJSONObject((Reader)new InputStreamReader(body, encoding)).toString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] xml2json(String xml) {
        return XML.toJSONObject((String)xml).toString().getBytes(StandardCharsets.UTF_8);
    }

    public static String loadXMLFromStream(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return Xml2JsonInterceptor.documentToString(factory.newDocumentBuilder().parse(stream));
    }

    public static String documentToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    @Override
    public String getDisplayName() {
        return "XML2JSON";
    }
}

