/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xml;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@MCElement(name="xpathExtractor")
public class XmlPathExtractorInterceptor
extends AbstractInterceptor {
    private List<Property> properties = new ArrayList<Property>();

    public XmlPathExtractorInterceptor() {
        this.name = "XmlPath";
    }

    @MCChildElement
    @Required
    public void setMappings(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getMappings() {
        return this.properties;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        return this.handleInternal(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleInternal(exc, exc.getResponse());
    }

    private Outcome handleInternal(Exchange exc, Message msg) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (!msg.isXML()) {
            return Outcome.CONTINUE;
        }
        this.setProperties(exc, msg.getBodyAsStream());
        return Outcome.CONTINUE;
    }

    private void setProperties(Exchange exc, InputStream body) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        for (Property m : this.properties) {
            NodeList list = this.getEvaluate(this.getDocument(body), m);
            if (list.getLength() > 1) {
                exc.setProperty(m.getName(), this.getPropertyAsList(list));
                continue;
            }
            exc.setProperty(m.getName(), list.item(0).getTextContent());
        }
    }

    private List<String> getPropertyAsList(NodeList list) {
        return IntStream.range(0, list.getLength()).mapToObj(i -> list.item(i).getTextContent()).collect(Collectors.toList());
    }

    private Document getDocument(InputStream body) throws ParserConfigurationException, SAXException, IOException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(body);
    }

    private NodeList getEvaluate(Document document, Property m) throws XPathExpressionException {
        return (NodeList)m.xpath.evaluate(document, XPathConstants.NODESET);
    }

    @MCElement(name="property", topLevel=false, id="xpath-map")
    public static class Property {
        String name;
        XPathExpression xpath;
        static XPathFactory xPathFactory = XPathFactory.newInstance();

        public Property() {
        }

        public Property(String xpath, String name) throws XPathExpressionException {
            this.name = name;
            this.setXpath(xpath);
        }

        public XPathExpression getXpath() {
            return this.xpath;
        }

        @MCAttribute
        @Required
        public void setXpath(String xpath) {
            try {
                this.xpath = xPathFactory.newXPath().compile(xpath);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(String.format("Wrong xpath expression %s with property %s", xpath, this.name), e);
            }
        }

        public String getName() {
            return this.name;
        }

        @MCAttribute
        @Required
        public void setName(String name) {
            this.name = name;
        }
    }
}

