/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlprotection;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xmlprotection.XMLProtector;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="xmlProtection")
public class XMLProtectionInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)XMLProtectionInterceptor.class.getName());
    private int maxAttibuteCount = 1000;
    private int maxElementNameLength = 1000;
    private boolean removeDTD = true;

    public XMLProtectionInterceptor() {
        this.name = "XML Protection";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().isBodyEmpty()) {
            log.info("body is empty -> request is not scanned by xmlProtection");
            return Outcome.CONTINUE;
        }
        if (!exc.getRequest().isXML()) {
            log.warn("request discarded by xmlProtection, because it's Content-Type header did not indicate that it is actually XML.");
            return Outcome.ABORT;
        }
        if (!this.protectXML(exc)) {
            log.warn("request discarded by xmlProtection, because it is not wellformed or exceeds limits");
            this.setFailResponse(exc);
            return Outcome.ABORT;
        }
        log.debug("protected against XML attacks");
        return Outcome.CONTINUE;
    }

    private void setFailResponse(Exchange exc) {
        exc.setResponse(Response.badRequest("Invalid XML features used in request.").build());
    }

    private boolean protectXML(Exchange exc) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLProtector protector = new XMLProtector(new OutputStreamWriter((OutputStream)stream, this.getCharset(exc)), this.removeDTD, this.maxElementNameLength, this.maxAttibuteCount);
        if (!protector.protect(new InputStreamReader(exc.getRequest().getBodyAsStreamDecoded(), this.getCharset(exc)))) {
            return false;
        }
        exc.getRequest().setBodyContent(stream.toByteArray());
        return true;
    }

    private String getCharset(Exchange exc) {
        String charset = exc.getRequest().getCharset();
        if (charset == null) {
            return "UTF-8";
        }
        return charset;
    }

    @MCAttribute
    public void setMaxAttibuteCount(int maxAttibuteCount) {
        this.maxAttibuteCount = maxAttibuteCount;
    }

    @MCAttribute
    public void setMaxElementNameLength(int maxElementNameLength) {
        this.maxElementNameLength = maxElementNameLength;
    }

    @MCAttribute
    public void setRemoveDTD(boolean removeDTD) {
        this.removeDTD = removeDTD;
    }

    @Override
    public String getShortDescription() {
        return "Protects agains XML attacks.";
    }
}

