/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xslt;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xslt.XSLTTransformer;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.TextUtil;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;

@MCElement(name="transform")
public class XSLTInterceptor
extends AbstractInterceptor {
    private String xslt;
    private volatile XSLTTransformer xsltTransformer;
    private XOPReconstitutor xopr = new XOPReconstitutor();

    public XSLTInterceptor() {
        this.name = "XSLT Transformer";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.transformMsg(exc.getRequest(), this.xslt, exc.getStringProperties());
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.transformMsg(exc.getResponse(), this.xslt, exc.getStringProperties());
        return Outcome.CONTINUE;
    }

    private void transformMsg(Message msg, String ss, Map<String, String> parameter) throws Exception {
        if (msg.isBodyEmpty()) {
            return;
        }
        msg.setBodyContent(this.xsltTransformer.transform(new StreamSource(this.xopr.reconstituteIfNecessary(msg)), parameter));
    }

    @Override
    public void init() throws Exception {
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.xsltTransformer = new XSLTTransformer(this.xslt, this.router, concurrency);
    }

    public String getXslt() {
        return this.xslt;
    }

    @MCAttribute
    public void setXslt(String xslt) {
        this.xslt = xslt;
        this.xsltTransformer = null;
    }

    @Override
    public String getShortDescription() {
        return "Applies an XSLT transformation.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextUtil.removeFinalChar(this.getShortDescription()));
        sb.append(" using the stylesheet at ");
        sb.append(TextUtil.linkURL(this.xslt));
        sb.append(" .");
        return sb.toString();
    }
}

