/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class KubernetesSchemaResolver
implements SchemaResolver {
    KubernetesClientFactory kubernetesClientFactory;
    KubernetesClient kc;

    public KubernetesSchemaResolver(@Nullable KubernetesClientFactory kubernetesClientFactory) {
        this.kubernetesClientFactory = kubernetesClientFactory;
    }

    private synchronized KubernetesClient getClient() {
        if (this.kc == null) {
            if (this.kubernetesClientFactory == null) {
                this.kubernetesClientFactory = new KubernetesClientFactory(null);
            }
            this.kc = this.kubernetesClientFactory.createClient(null);
        }
        return this.kc;
    }

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"kubernetes"});
    }

    @Override
    public InputStream resolve(String url) throws ResourceRetrievalException {
        try {
            if (!url.startsWith("kubernetes:")) {
                throw new IllegalArgumentException();
            }
            if ((url = url.substring(11)).startsWith("secret:")) {
                url = url.substring(7);
                int p = url.indexOf(47);
                String namespace = url.substring(0, p);
                url = url.substring(p + 1);
                p = url.indexOf(47);
                String name = url.substring(0, p);
                String key = url.substring(p + 1);
                Map secret = this.getClient().read("v1", "Secret", namespace, name);
                String res = (String)((Map)secret.get("data")).get(key);
                return new ByteArrayInputStream(Base64.getDecoder().decode(res));
            }
            throw new ResourceRetrievalException(url);
        }
        catch (ResourceRetrievalException e) {
            throw e;
        }
        catch (Exception e) {
            ResourceRetrievalException rre = new ResourceRetrievalException(url, e);
            throw rre;
        }
    }

    @Override
    public void observeChange(String url, Consumer<InputStream> consumer) throws ResourceRetrievalException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public List<String> getChildren(String url) {
        return null;
    }

    @Override
    public long getTimestamp(String url) {
        return 0L;
    }
}

