/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.predic8.membrane.core.config.security.Certificate;
import com.predic8.membrane.core.config.security.Key;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.config.security.Trust;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.LogInterceptor;
import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KubernetesClientBuilder {
    private static final String TOKEN_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String CA_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String NAMESPACE_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private boolean logHttp = false;
    HttpClientFactory httpClientFactory;
    String baseURL;
    String ca;
    String cert;
    String key;
    String token;
    String namespace;

    KubernetesClientBuilder(String baseURL, String ca, String cert, String key, String token, String namespace) {
        this.baseURL = baseURL;
        this.ca = ca;
        this.cert = cert;
        this.key = key;
        this.token = token;
        this.namespace = namespace;
    }

    public static KubernetesClientBuilder newBuilder() {
        return new KubernetesClientBuilder(null, null, null, null, null, null);
    }

    public static KubernetesClientBuilder auto() throws ParsingException {
        if (new File(TOKEN_FILE).exists()) {
            return KubernetesClientBuilder.inClusterConfig();
        }
        return KubernetesClientBuilder.kubeConfig();
    }

    private static KubernetesClientBuilder inClusterConfig() throws ParsingException {
        try {
            String baseURL = "https://kubernetes.default.svc";
            String ca = Files.asCharSource((File)new File(CA_FILE), (Charset)Charsets.UTF_8).read();
            String token = Files.asCharSource((File)new File(TOKEN_FILE), (Charset)Charsets.UTF_8).read();
            String namespace = Files.asCharSource((File)new File(NAMESPACE_FILE), (Charset)Charsets.UTF_8).read();
            return new KubernetesClientBuilder(baseURL, ca, null, null, token, namespace);
        }
        catch (IOException e) {
            throw new ParsingException("while building in-cluster KubernetesClient config", e);
        }
    }

    private static KubernetesClientBuilder kubeConfig() throws ParsingException {
        try {
            File baseDir = new File(new File(System.getProperty("user.home")), ".kube");
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Map kubeConfig = (Map)mapper.readValue(new File(baseDir, "config"), Map.class);
            String currentContext = (String)kubeConfig.get("current-context");
            Map context = ((List)kubeConfig.get("contexts")).stream().filter(m -> m.get("name").equals(currentContext)).findFirst().orElse(null);
            String currentCluster = (String)((Map)context.get("context")).get("cluster");
            String currentUser = (String)((Map)context.get("context")).get("user");
            String namespace = (String)((Map)context.get("context")).get("namespace");
            Map cluster = ((List)kubeConfig.get("clusters")).stream().filter(m -> m.get("name").equals(currentCluster)).findFirst().orElse(null);
            String baseURL = (String)((Map)cluster.get("cluster")).get("server");
            Map user = ((List)kubeConfig.get("users")).stream().filter(m -> m.get("name").equals(currentUser)).findFirst().orElse(null);
            String ca = KubernetesClientBuilder.getReferencedFile(baseDir, (String)((Map)cluster.get("cluster")).get("certificate-authority"));
            String cert = null;
            String key = null;
            String token = null;
            if (user != null) {
                Map config;
                Map authP;
                token = (String)((Map)user.get("user")).get("token");
                if (token == null && (authP = (Map)((Map)user.get("user")).get("auth-provider")) != null && (config = (Map)authP.get("config")) != null) {
                    token = (String)config.get("id-token");
                }
                cert = KubernetesClientBuilder.getReferencedFile(baseDir, (String)((Map)user.get("user")).get("client-certificate"));
                key = KubernetesClientBuilder.getReferencedFile(baseDir, (String)((Map)user.get("user")).get("client-key"));
            }
            return new KubernetesClientBuilder(baseURL, ca, cert, key, token, namespace);
        }
        catch (IOException e) {
            throw new ParsingException("while parsing ~/.kube/config", e);
        }
    }

    public KubernetesClientBuilder baseURL(String baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    public KubernetesClient build() {
        Consumer<Exchange> lastClient;
        if (this.httpClientFactory == null) {
            this.httpClientFactory = new HttpClientFactory(null);
        }
        HttpClientConfiguration config = new HttpClientConfiguration();
        config.setUseExperimentalHttp2(true);
        HttpClient hc = this.httpClientFactory.createClient(config);
        Consumer<Exchange> client = hc::call;
        if (this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL.substring(0, this.baseURL.length() - 1);
        }
        if (this.baseURL.startsWith("https")) {
            SSLParser sslParser = new SSLParser();
            if (this.key != null && this.cert != null) {
                Key key1 = new Key();
                Key.Private private_ = new Key.Private();
                private_.setContent(this.key);
                key1.setPrivate(private_);
                key1.setCertificates(KubernetesClientBuilder.certList(this.cert));
                sslParser.setKey(key1);
            }
            if (this.ca != null) {
                Trust trust = new Trust();
                trust.setCertificateList(KubernetesClientBuilder.certList(this.ca));
                sslParser.setTrust(trust);
            }
            StaticSSLContext sslContext = new StaticSSLContext(sslParser, null, null);
            Consumer<Exchange> lastClient2 = client;
            client = exchange -> {
                exchange.setProperty("SSL_CONTEXT", sslContext);
                lastClient2.call((Exchange)exchange);
            };
        }
        if (this.token != null) {
            lastClient = client;
            String theToken = this.token;
            client = exchange -> {
                exchange.getRequest().getHeader().add("Authorization", "Bearer " + theToken);
                lastClient.call((Exchange)exchange);
            };
        }
        if (this.logHttp) {
            lastClient = client;
            LogInterceptor i = new LogInterceptor();
            i.setLevel(LogInterceptor.Level.WARN);
            i.setHeaderOnly(false);
            client = exchange -> {
                i.handleRequest((Exchange)exchange);
                lastClient.call((Exchange)exchange);
                i.handleResponse((Exchange)exchange);
            };
        }
        return new KubernetesClient(client, this.baseURL, this.namespace);
    }

    private static List<Certificate> certList(String certs) {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        for (String cert : certs.split("(?<=-----)\r?\n(?=-----)")) {
            Certificate cert1 = new Certificate();
            cert1.setContent(cert);
            certificates.add(cert1);
        }
        return certificates;
    }

    private static String getReferencedFile(File baseDir, String filePath) throws IOException {
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        File absolutePath = file.isAbsolute() ? file : new File(baseDir, filePath);
        return Files.asCharSource((File)absolutePath, (Charset)Charsets.UTF_8).read();
    }

    public KubernetesClientBuilder log(boolean log) {
        this.logHttp = log;
        return this;
    }

    public KubernetesClientBuilder httpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
        return this;
    }

    public static class ParsingException
    extends Exception {
        public ParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

