/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.kubernetes.client.HttpException;
import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Schema {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    private final Map s20;
    private final Map apis;

    public Schema(Map s20, Map apis) {
        this.s20 = s20;
        this.apis = apis;
    }

    public static Schema getSchema(KubernetesClient client, ObjectMapper om) throws IOException, HttpException {
        HttpException exc;
        Map s20;
        block6: {
            s20 = null;
            exc = null;
            try {
                s20 = (Map)om.readValue(Schema.get(client, "/openapi/v2"), Map.class);
            }
            catch (HttpException e) {
                exc = e;
            }
            if (s20 == null) {
                try {
                    s20 = (Map)om.readValue(Schema.get(client, "/swagger-2.0.0.json"), Map.class);
                }
                catch (HttpException e) {
                    if (exc != null) break block6;
                    exc = e;
                }
            }
        }
        if (exc != null) {
            throw exc;
        }
        Map apis = (Map)om.readValue(Schema.get(client, "/apis"), Map.class);
        HashMap r = new HashMap();
        ((List)apis.get("groups")).forEach(g -> {
            Map group = (Map)g;
            HashMap groupInfo = new HashMap();
            r.put(group.get("name"), groupInfo);
            ((List)group.get("versions")).forEach(v -> {
                Map version = (Map)v;
                String theVersion = (String)version.get("version");
                try {
                    Map versionInfo = (Map)om.readValue(Schema.getWithRetries(client, "/apis/" + group.get("name") + "/" + theVersion), Map.class);
                    groupInfo.put(theVersion, versionInfo);
                }
                catch (Exception e) {
                    LOG.warn("Could not retrieve /apis/" + group.get("name") + "/" + theVersion + ": " + e.getMessage());
                }
            });
        });
        return new Schema(s20, r);
    }

    static InputStream get(KubernetesClient client, String path) throws IOException, HttpException {
        Exchange e = null;
        try {
            e = new Request.Builder().get(client.getBaseURL() + path).buildExchange();
            client.getClient().call(e);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (e.getResponse().getStatusCode() != 200) {
            e.getResponse().getBodyAsStringDecoded();
            throw new HttpException(e.getResponse().getStatusCode(), "retrieving " + path + " caused " + e.getResponse().getStatusMessage());
        }
        return e.getResponse().getBodyAsStreamDecoded();
    }

    static InputStream getWithRetries(KubernetesClient client, String path) throws IOException, HttpException {
        Exception ex = null;
        for (int i = 0; i < 30; ++i) {
            try {
                return Schema.get(client, path);
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (HttpException | IOException e) {
                ex = e;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (ex instanceof HttpException) {
            throw (HttpException)ex;
        }
        throw (IOException)ex;
    }

    public String getPath(String verb, String apiVersion, String kind, boolean forAllNamespaces) {
        AtomicReference thepath = new AtomicReference();
        ((Map)this.s20.get("paths")).forEach((path, methods) -> ((Map)methods).forEach((method, data) -> {
            try {
                if (data instanceof ArrayList) {
                    return;
                }
                Object apiv = apiVersion;
                if (!apiVersion.contains("/")) {
                    apiv = "core/" + (String)apiv;
                }
                apiv = ((String)apiv).replaceAll("/", "").replaceAll("\\.k8s\\.io", "").replaceAll("[.-]", "");
                String operationId = (String)((Map)data).get("operationId");
                if (forAllNamespaces && operationId.equalsIgnoreCase(verb + (String)apiv + kind + "ForAllNamespaces")) {
                    thepath.set((String)path);
                }
                if (operationId.equalsIgnoreCase(verb + (String)apiv + kind) && thepath.get() == null) {
                    thepath.set((String)path);
                }
                if (!forAllNamespaces && operationId.equalsIgnoreCase(verb + (String)apiv + "Namespaced" + kind)) {
                    thepath.set((String)path);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(path + " " + method, e);
            }
        }));
        if (thepath.get() == null) {
            Map api;
            String verb2;
            String[] av = apiVersion.split("/", 2);
            String string = verb2 = verb.equals("read") ? "get" : verb;
            if (av.length == 2 && this.apis != null && this.apis.get(av[0]) != null && (api = (Map)((Map)this.apis.get(av[0])).get(av[1])) != null) {
                ((List)api.get("resources")).forEach(res -> {
                    if (((Map)res).get("kind").equals(kind) && ((List)((Map)res).get("verbs")).contains(verb2)) {
                        thepath.set("/apis/" + api.get("groupVersion") + "/namespaces/{namespace}/" + ((Map)res).get("name") + (verb2.equals("list") || verb2.equals("create") ? "" : "/{name}"));
                    }
                });
            }
        }
        if (thepath.get() == null) {
            throw new RuntimeException("Could not determine path for " + apiVersion + "/" + kind + " .");
        }
        return (String)thepath.get();
    }
}

