/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractScriptInterceptor
extends AbstractInterceptor {
    protected String src;
    protected Function<Map<String, Object>, Object> script;

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void init() throws IOException, ClassNotFoundException {
        if (this.router == null) {
            return;
        }
        if ("".equals(this.src)) {
            return;
        }
        this.initInternal();
    }

    protected abstract void initInternal() throws IOException, ClassNotFoundException;

    protected Outcome runScript(Exchange exc, Interceptor.Flow flow) throws InterruptedException, IOException, ClassNotFoundException {
        Object res = this.script.apply(this.getParameterBindings(exc, flow));
        if (res instanceof Outcome) {
            return (Outcome)((Object)res);
        }
        if (res instanceof Response) {
            exc.setResponse((Response)res);
            return Outcome.RETURN;
        }
        if (res instanceof Request) {
            exc.setRequest((Request)res);
        }
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.runScript(exc, Interceptor.Flow.ABORT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, Object> getParameterBindings(Exchange exc, Interceptor.Flow flow) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("exc", exc);
        parameters.put("flow", (Object)flow);
        Message msg = this.getMessage(exc, flow);
        if (msg != null) {
            parameters.put("message", msg);
            parameters.put("header", msg.getHeader());
            parameters.put("body", msg.getBody());
        }
        parameters.put("spring", this.router.getBeanFactory());
        this.addOutcomeObjects(parameters);
        return parameters;
    }

    private void addOutcomeObjects(HashMap<String, Object> parameters) {
        parameters.put("Outcome", Outcome.class);
        parameters.put("RETURN", (Object)Outcome.RETURN);
        parameters.put("CONTINUE", (Object)Outcome.CONTINUE);
        parameters.put("ABORT", (Object)Outcome.ABORT);
    }

    protected Message getMessage(Exchange exc, Interceptor.Flow flow) {
        return switch (flow) {
            case Interceptor.Flow.REQUEST -> exc.getRequest();
            case Interceptor.Flow.RESPONSE -> exc.getResponse();
            default -> null;
        };
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }
}

