/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.javascript;

import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalVMJavascriptSupport
extends LanguageSupport {
    private static final Logger log = LoggerFactory.getLogger(GraalVMJavascriptSupport.class);

    @Override
    public Function<Map<String, Object>, Boolean> compileExpression(ExecutorService executorService, ClassLoader cl, String src) {
        return new GraalVMJavascriptExecutorPool<Boolean>(executorService, src){

            @Override
            public Boolean apply(Map<String, Object> parameters) {
                Object result = this.execute(parameters);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return false;
            }
        };
    }

    @Override
    public Function<Map<String, Object>, Object> compileScript(ExecutorService executorService, ClassLoader cl, String script) {
        return new GraalVMJavascriptExecutorPool<Object>(executorService, script){

            @Override
            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private static abstract class GraalVMJavascriptExecutorPool<R>
    extends ScriptExecutorPool<Source, R> {
        private static final Context context = Context.newBuilder((String[])new String[0]).allowHostAccess(HostAccess.ALL).allowHostClassLookup(s -> true).allowPolyglotAccess(PolyglotAccess.ALL).build();
        private final String javascriptCode;

        private GraalVMJavascriptExecutorPool(ExecutorService executorService, String expression) {
            this.javascriptCode = expression;
            this.init(executorService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object invoke(Source source, Map<String, Object> parameters) {
            try {
                Context context = GraalVMJavascriptExecutorPool.context;
                synchronized (context) {
                    for (String name : parameters.keySet()) {
                        GraalVMJavascriptExecutorPool.context.getBindings("js").putMember(name, parameters.get(name));
                    }
                    Value js = GraalVMJavascriptExecutorPool.context.eval(source);
                    if (js.isHostObject()) {
                        return js.asHostObject();
                    }
                    return js;
                }
            }
            catch (PolyglotException e) {
                if (e.isSyntaxError()) {
                    SourceSection location = e.getSourceLocation();
                    log.warn("Syntax error compiling Javascript at {} line {} position {}", new Object[]{location.getSource(), location.getStartLine(), location.getCharIndex()});
                    log.warn("Location " + location);
                } else {
                    log.warn("");
                }
                throw e;
            }
            catch (Exception e) {
                log.error("Error compiling script:", (Throwable)e);
                throw new RuntimeException("Error compiling script:", e);
            }
        }

        @Override
        protected Source createOneScript() {
            return Source.create((String)"js", (CharSequence)this.javascriptCode);
        }
    }
}

