/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.javascript;

import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoJavascriptLanguageSupport
extends LanguageSupport {
    private static final Logger log = LoggerFactory.getLogger(RhinoJavascriptLanguageSupport.class);

    @Override
    public Function<Map<String, Object>, Boolean> compileExpression(ExecutorService executorService, ClassLoader classLoader, String src) {
        return new JavascriptScriptExecutorPool<Boolean>(executorService, classLoader, src){

            @Override
            public Boolean apply(Map<String, Object> parameters) {
                Object result = this.execute(parameters);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return false;
            }
        };
    }

    @Override
    public Function<Map<String, Object>, Object> compileScript(ExecutorService executorService, ClassLoader classLoader, String script) {
        return new JavascriptScriptExecutorPool<Object>(executorService, classLoader, script){

            @Override
            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private static abstract class JavascriptScriptExecutorPool<R>
    extends ScriptExecutorPool<ScriptEngine, R> {
        private final String javascriptCode;
        protected final ScriptEngineManager sce;
        protected static final String javascriptEngineName = "rhino";

        private JavascriptScriptExecutorPool(ExecutorService executorService, ClassLoader classLoader, String expression) {
            this.javascriptCode = expression;
            this.sce = new ScriptEngineManager(classLoader);
            this.init(executorService);
        }

        @Override
        protected Object invoke(ScriptEngine script, Map<String, Object> parameters) {
            for (String name : parameters.keySet()) {
                script.put(name, parameters.get(name));
            }
            try {
                return script.eval(this.javascriptCode);
            }
            catch (ScriptException e) {
                log.error("Error compiling script:" + e.getMessage());
                log.error("Script:");
                log.error(this.javascriptCode);
                throw new RuntimeException("Error compiling script:", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ScriptEngine createOneScript() {
            ScriptEngineManager scriptEngineManager = this.sce;
            synchronized (scriptEngineManager) {
                return this.sce.getEngineByName(javascriptEngineName);
            }
        }
    }
}

