/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.model.Response;
import com.predic8.membrane.core.openapi.util.MethodNotAllowException;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.validators.OperationValidator;
import com.predic8.membrane.core.openapi.validators.PathParametersValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.FileUtil;
import com.predic8.membrane.core.util.URIFactory;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIValidator {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIValidator.class.getName());
    private final OpenAPI api;
    private URIFactory uriFactory;
    private String basePath = "";

    public OpenAPIValidator(URIFactory uriFactory, OpenAPI api) {
        this.api = api;
        this.uriFactory = uriFactory;
        this.init();
    }

    public OpenAPIValidator(URIFactory uriFactory, InputStream openApiIs) {
        this.api = new OpenAPIParser().readContents(FileUtil.readInputStream(openApiIs), null, null).getOpenAPI();
        this.uriFactory = uriFactory;
        this.init();
    }

    public OpenAPIValidator(String openApiUrl, URIFactory uriFactory) {
        this.api = new OpenAPIParser().readLocation(openApiUrl, null, null).getOpenAPI();
        this.uriFactory = uriFactory;
        this.init();
    }

    private void init() {
        if (this.api.getServers() != null) {
            String url = ((Server)this.api.getServers().get(0)).getUrl();
            log.debug("Found server " + url);
            try {
                this.basePath = UriUtil.getPathFromURL(this.uriFactory, url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Config Error ", e);
            }
        }
    }

    public ValidationErrors validate(Request request) {
        return this.validateMessage(request, null);
    }

    public ValidationErrors validateResponse(Request request, Response response) {
        return this.validateMessage(request, response);
    }

    private ValidationErrors validateMessage(Request req, Response response) {
        ValidationContext ctx = ValidationContext.fromRequest(req);
        ValidationErrors errors = new ValidationErrors();
        AtomicBoolean pathFound = new AtomicBoolean(false);
        this.api.getPaths().forEach((uriTemplate, pathItem) -> {
            if (pathFound.get()) {
                return;
            }
            try {
                req.parsePathParameters(UriUtil.normalizeUri(this.basePath + uriTemplate));
                pathFound.set(true);
            }
            catch (PathDoesNotMatchException ignore) {
                return;
            }
            catch (UnsupportedEncodingException e) {
                log.warn(String.format("Cannot decode path %s/%s. Request will be rejected.", this.basePath, uriTemplate));
                return;
            }
            errors.add(this.validateMethods(ctx.uriTemplate((String)uriTemplate), req, response, (PathItem)pathItem));
            if (response == null) {
                PathParametersValidator pathParametersValidator = new PathParametersValidator(this.api);
                errors.add(pathParametersValidator.validatePathParameters(ctx.uriTemplate((String)uriTemplate), req, pathItem.getParameters()));
            }
        });
        if (!pathFound.get()) {
            errors.add(new ValidationError(ctx.validatedEntity(req.getPath()).validatedEntityType(ValidationContext.ValidatedEntityType.PATH).statusCode(404), String.format("Path %s is invalid.", req.getPath())));
        }
        return errors;
    }

    private ValidationErrors validateMethods(ValidationContext ctx, Request req, Response response, PathItem pathItem) {
        ValidationErrors errors = new ValidationErrors();
        try {
            return errors.add(new OperationValidator(this.api).validateOperation(ctx, req, response, pathItem));
        }
        catch (MethodNotAllowException e) {
            return errors.add(ctx.statusCode(405).validatedEntity(req.getMethod()).validatedEntityType(ValidationContext.ValidatedEntityType.METHOD), String.format("Method %s is not allowed", req.getMethod()));
        }
    }
}

