/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.InputStreamBody;
import com.predic8.membrane.core.openapi.model.JsonBody;
import com.predic8.membrane.core.openapi.model.NoBody;
import com.predic8.membrane.core.openapi.model.StringBody;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message<T> {
    private static Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    protected Body body = new NoBody();
    protected ContentType mediaType;

    protected Message(String mediaType) throws ParseException {
        this.mediaType = new ContentType(mediaType);
    }

    protected Message() {
    }

    public Body getBody() {
        return this.body;
    }

    public T body(Body body) {
        this.body = body;
        if (body instanceof JsonBody) {
            this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        }
        return (T)this;
    }

    public T body(InputStream inputStream) {
        this.body = new InputStreamBody(inputStream);
        return (T)this;
    }

    public T body(String s) {
        this.body = new StringBody(s);
        return (T)this;
    }

    public T body(JsonNode n) {
        this.body = new JsonBody(n);
        this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        return (T)this;
    }

    public T mediaType(String mediaType) throws ParseException {
        this.mediaType = new ContentType(mediaType);
        return (T)this;
    }

    public boolean isOfMediaType(String mediaType) {
        return this.mediaType.match(mediaType);
    }

    public boolean hasBody() {
        if (this.body == null) {
            return false;
        }
        return !(this.body instanceof NoBody);
    }

    public T json() {
        this.mediaType = MimeType.APPLICATION_JSON_CONTENT_TYPE;
        return (T)this;
    }

    public ContentType getMediaType() {
        return this.mediaType;
    }
}

