/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.model;

import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriTemplateMatcher;
import com.predic8.membrane.core.openapi.util.UriUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class Request
extends Message<Request> {
    private String method;
    private String path;
    private UriTemplateMatcher uriTemplateMatcher = new UriTemplateMatcher();
    private Map<String, String> pathParameters;

    public Request(String method) {
        this.method = method;
    }

    public static Request get() {
        return new Request("GET");
    }

    public static Request post() {
        return new Request("POST");
    }

    public static Request put() {
        return new Request("PUT");
    }

    public static Request delete() {
        return new Request("DELETE");
    }

    public static Request patch() {
        return new Request("PATCH");
    }

    public static Request trace() {
        return new Request("TRACE");
    }

    public Request path(String path) {
        this.path = path;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getQueryParams() {
        return UriUtil.parseQueryString(this.path);
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, String> parsePathParameters(String uriTemplate) throws PathDoesNotMatchException, UnsupportedEncodingException {
        if (this.pathParameters == null) {
            this.pathParameters = this.uriTemplateMatcher.match(uriTemplate, this.path);
        }
        return this.pathParameters;
    }

    public String toString() {
        return "Request{method='" + this.method + "', path='" + this.path + "', uriTemplateMatcher=" + this.uriTemplateMatcher + ", pathParameters=" + this.pathParameters + "}";
    }
}

