/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.model.InputStreamBody;
import com.predic8.membrane.core.openapi.model.JsonBody;
import com.predic8.membrane.core.openapi.model.Message;
import jakarta.mail.internet.ParseException;
import java.io.InputStream;

public class Response
extends Message<Response> {
    private int statusCode;

    public Response(int statusCode) {
        this.statusCode = statusCode;
    }

    public Response(int statusCode, String mediaType) throws ParseException {
        super(mediaType);
        this.statusCode = statusCode;
    }

    public static Response statusCode(int statusCode) {
        return new Response(statusCode);
    }

    @Override
    public Response body(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public Response body(InputStream inputStream) {
        this.body = new InputStreamBody(inputStream);
        return this;
    }

    @Override
    public Response body(JsonNode n) {
        this.body = new JsonBody(n);
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean sameStatusCode(String other) {
        return Integer.toString(this.statusCode).equals(other);
    }
}

