/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.OpenAPIValidator;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIProxy;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import redis.clients.jedis.HostAndPort;

public class OpenAPIInterceptor
extends AbstractInterceptor {
    protected final OpenAPIProxy proxy;

    public OpenAPIInterceptor(OpenAPIProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        ValidationErrors errors;
        String basePath = this.getMatchingBasePath(exc);
        if (basePath == null) {
            exc.setResponse(Response.notFound().contentType("application/json;charset=utf-8").body(this.errorJson("No matching API found!")).build());
            return Outcome.RETURN;
        }
        OpenAPI api = this.proxy.getBasePaths().get(basePath);
        if (this.proxy.getTarget() == null || this.proxy.getTarget().getHost() == null && this.proxy.getTarget().getUrl() == null) {
            this.setDestinationsFromOpenAPI(api, exc);
        }
        if ((errors = this.validateRequest(api, exc)) != null && errors.size() > 0) {
            this.proxy.statisticCollector.collect(errors);
            return this.returnErrors(exc, errors, ValidationErrors.Direction.REQUEST, this.validationDetails(api));
        }
        exc.setProperty("openApi", api);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        OpenAPI api = (OpenAPI)exc.getProperty("openApi");
        ValidationErrors errors = this.validateResponse(api, exc);
        if (errors != null && errors.size() > 0) {
            exc.getResponse().setStatusCode(500);
            this.proxy.statisticCollector.collect(errors);
            return this.returnErrors(exc, errors, ValidationErrors.Direction.RESPONSE, this.validationDetails(api));
        }
        return Outcome.CONTINUE;
    }

    private byte[] errorJson(String msg) {
        return String.format("{ \"error\": \"%s\"}", msg).getBytes();
    }

    protected String getMatchingBasePath(Exchange exc) {
        for (String basePath : this.proxy.getBasePaths().keySet()) {
            if (!exc.getRequest().getUri().startsWith(basePath)) continue;
            return basePath;
        }
        return null;
    }

    private ValidationErrors validateRequest(OpenAPI api, Exchange exc) throws IOException, ParseException {
        ValidationErrors errors = new ValidationErrors();
        if (!this.shouldValidate(api, "requests")) {
            return errors;
        }
        return new OpenAPIValidator(this.router.getUriFactory(), api).validate(Utils.getOpenapiValidatorRequest(exc));
    }

    private ValidationErrors validateResponse(OpenAPI api, Exchange exc) throws IOException, ParseException {
        ValidationErrors errors = new ValidationErrors();
        if (!this.shouldValidate(api, "responses")) {
            return errors;
        }
        return new OpenAPIValidator(this.router.getUriFactory(), api).validateResponse(Utils.getOpenapiValidatorRequest(exc), Utils.getOpenapiValidatorResponse(exc));
    }

    public boolean validationDetails(OpenAPI api) {
        if (api.getExtensions() == null) {
            return true;
        }
        Map xValidation = (Map)api.getExtensions().get("x-membrane-validation");
        if (xValidation == null) {
            return true;
        }
        Boolean validationDetails = (Boolean)xValidation.get("details");
        if (xValidation.get("details") == null) {
            return true;
        }
        return validationDetails;
    }

    private boolean shouldValidate(OpenAPI api, String direction) {
        Map extenstions = api.getExtensions();
        if (extenstions == null) {
            return false;
        }
        Map<String, Boolean> xValidation = this.getxValidation(extenstions);
        return xValidation != null && xValidation.get(direction) != false;
    }

    private Map<String, Boolean> getxValidation(Map<String, Object> extenstions) {
        return (Map)extenstions.get("x-membrane-validation");
    }

    protected void setDestinationsFromOpenAPI(OpenAPI api, Exchange exc) {
        exc.getDestinations().clear();
        api.getServers().forEach(server -> {
            URL url;
            try {
                url = new URL(server.getUrl());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot parse server address from OpenAPI " + server.getUrl());
            }
            this.setHostHeader(exc, url);
            exc.setProperty("SNI_SERVER_NAME", url.getHost());
            exc.getDestinations().add(UriUtil.getUrlWithoutPath(url) + exc.getRequest().getUri());
        });
    }

    @Override
    public String getDisplayName() {
        return "OpenAPI";
    }

    @Override
    public String getShortDescription() {
        return "Autoconfiguration from OpenAPI";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<thead><th>API</th><th>Base Path</th><th>Validation</th></thead>");
        for (Map.Entry<String, OpenAPI> entry : this.proxy.getBasePaths().entrySet()) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(entry.getValue().getInfo().getTitle());
            sb.append("</td>");
            sb.append("<td>");
            sb.append(entry.getKey());
            sb.append("</td>");
            sb.append("<td>");
            if (entry.getValue().getExtensions() != null && entry.getValue().getExtensions().get("x-membrane-validation") != null) {
                sb.append(entry.getValue().getExtensions().get("x-membrane-validation"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private void setHostHeader(Exchange exc, URL url) {
        exc.getRequest().getHeader().setHost(new HostAndPort(url.getHost(), url.getPort()).toString());
    }

    private Outcome returnErrors(Exchange exc, ValidationErrors errors, ValidationErrors.Direction direction, boolean validationDetails) {
        exc.setResponse(Response.ResponseBuilder.newInstance().status(errors.get(0).getContext().getStatusCode(), "Bad Request").body(this.getErrorMessage(errors, direction, validationDetails)).contentType("application/json;charset=utf-8").build());
        return Outcome.RETURN;
    }

    private byte[] getErrorMessage(ValidationErrors errors, ValidationErrors.Direction direction, boolean validationDetails) {
        if (validationDetails) {
            return errors.getErrorMessage(direction);
        }
        return Utils.createErrorMessage("Message validation failed!");
    }
}

