/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIInterceptor;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIProxyServiceKey;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIPublisherInterceptor;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecordFactory;
import com.predic8.membrane.core.openapi.serviceproxy.ValidationStatisticsCollector;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.ServiceProxy;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="api")
public class OpenAPIProxy
extends ServiceProxy {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIProxy.class.getName());
    public static final String X_MEMBRANE_VALIDATION = "x-membrane-validation";
    public static final String X_MEMBRANE_ID = "x-membrane-id";
    public static final String REQUESTS = "requests";
    public static final String RESPONSES = "responses";
    public static final String VALIDATION_DETAILS = "details";
    protected Map<String, OpenAPIRecord> apiRecords = new LinkedHashMap<String, OpenAPIRecord>();
    protected Map<String, OpenAPI> basePaths;
    protected ValidationStatisticsCollector statisticCollector = new ValidationStatisticsCollector();
    protected List<Spec> specs = new ArrayList<Spec>();

    @Override
    protected AbstractProxy getNewInstance() {
        return new OpenAPIProxy();
    }

    public List<Spec> getSpecs() {
        return this.specs;
    }

    @MCChildElement(order=25)
    public void setSpecs(List<Spec> specs) {
        this.specs = specs;
    }

    @Override
    public void init() throws Exception {
        if (this.specs.size() > 0) {
            this.key = new OpenAPIProxyServiceKey(this.getIp(), this.getHost(), this.getPort());
        }
        super.init();
        this.initOpenAPI();
    }

    private void initOpenAPI() throws IOException, ClassNotFoundException {
        if (this.specs.size() == 0) {
            return;
        }
        this.apiRecords = new OpenAPIRecordFactory(this.router).create(this.specs);
        this.basePaths = this.getOpenAPIMap();
        this.configureBasePaths();
        this.interceptors.add(new OpenAPIPublisherInterceptor(this.apiRecords));
        this.interceptors.add(new OpenAPIInterceptor(this));
    }

    private void configureBasePaths() {
        ((OpenAPIProxyServiceKey)this.key).addBasePaths(new ArrayList<String>(this.basePaths.keySet()));
    }

    private Map<String, OpenAPI> getOpenAPIMap() {
        HashMap<String, OpenAPI> basePaths = new HashMap<String, OpenAPI>();
        this.apiRecords.forEach((id, record) -> record.api.getServers().forEach(server -> {
            try {
                basePaths.put(UriUtil.getPathFromURL(this.router.getUriFactory(), server.getUrl()), record.api);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }));
        return basePaths;
    }

    public ValidationStatisticsCollector getValidationStatisticCollector() {
        return this.statisticCollector;
    }

    public Map<String, OpenAPI> getBasePaths() {
        return this.basePaths;
    }

    @MCElement(name="openapi", topLevel=false)
    public static class Spec {
        String location;
        String dir;
        YesNoOpenAPIOption validateRequests = YesNoOpenAPIOption.ASINOPENAPI;
        YesNoOpenAPIOption validateResponses = YesNoOpenAPIOption.ASINOPENAPI;
        YesNoOpenAPIOption validationDetails = YesNoOpenAPIOption.ASINOPENAPI;

        public String getLocation() {
            return this.location;
        }

        @MCAttribute
        public void setLocation(String location) {
            this.location = location;
        }

        public String getDir() {
            return this.dir;
        }

        @MCAttribute
        public void setDir(String dir) {
            this.dir = dir;
        }

        public YesNoOpenAPIOption getValidateRequests() {
            return this.validateRequests;
        }

        @MCAttribute
        public void setValidateRequests(YesNoOpenAPIOption validateRequests) {
            this.validateRequests = validateRequests;
        }

        public YesNoOpenAPIOption getValidateResponses() {
            return this.validateResponses;
        }

        @MCAttribute
        public void setValidateResponses(YesNoOpenAPIOption validateResponses) {
            this.validateResponses = validateResponses;
        }

        @MCAttribute
        public void setValidationDetails(YesNoOpenAPIOption validationDetails) {
            this.validationDetails = validationDetails;
        }

        public YesNoOpenAPIOption getValidationDetails() {
            return this.validationDetails;
        }

        public static enum YesNoOpenAPIOption {
            YES,
            NO,
            ASINOPENAPI;

        }
    }
}

