/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.core.rules.ServiceProxyKey;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIProxyServiceKey
extends ServiceProxyKey {
    private static Logger log = LoggerFactory.getLogger((String)OpenAPIProxyServiceKey.class.getName());
    ArrayList<String> basePaths = new ArrayList();

    public OpenAPIProxyServiceKey(String ip, String host, int port) {
        super(host, "*", null, port, ip);
        this.basePaths.add("/api-doc");
        this.basePaths.add("/api-doc/ui");
    }

    @Override
    public boolean isMethodWildcard() {
        return true;
    }

    @Override
    public boolean complexMatch(String hostHeader, String method, String uri, String version, int port, String localIP) {
        for (String basePath : this.basePaths) {
            if (!uri.startsWith(basePath)) continue;
            log.debug("Rule matches " + uri);
            return true;
        }
        return false;
    }

    @Override
    public String getPath() {
        return "*";
    }

    void addBasePaths(ArrayList<String> paths) {
        this.basePaths.addAll(paths);
    }
}

