/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.openapi.util.Utils;
import groovy.text.StreamingTemplateEngine;
import groovy.text.Template;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenAPIPublisherInterceptor
extends AbstractInterceptor {
    public static final String HTML_UTF_8 = "text/html; charset=utf-8";
    private final ObjectMapper om = new ObjectMapper();
    private final ObjectWriter ow = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private final ObjectMapper omYaml = ObjectMapperFactory.createYaml();
    public static final String PATH = "/api-doc";
    public static final String PATH_UI = "/api-doc/ui";
    private static final Pattern patternMeta = Pattern.compile("/api-doc/(.*)");
    private static final Pattern patternUI = Pattern.compile("/api-doc/ui/(.*)");
    protected Map<String, OpenAPIRecord> apis;
    private Template swaggerUiHtmlTemplate;
    private Template apiOverviewHtmlTemplate;

    public OpenAPIPublisherInterceptor(Map<String, OpenAPIRecord> apis) throws IOException, ClassNotFoundException {
        this.apis = apis;
        this.swaggerUiHtmlTemplate = this.createTemplate("/openapi/swagger-ui.html");
        this.apiOverviewHtmlTemplate = this.createTemplate("/openapi/overview.html");
    }

    private Template createTemplate(String filePath) throws ClassNotFoundException, IOException {
        return new StreamingTemplateEngine().createTemplate((Reader)new InputStreamReader(Utils.getResourceAsStream(this, filePath)));
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (!exc.getRequest().getUri().startsWith(PATH)) {
            return Outcome.CONTINUE;
        }
        if (exc.getRequest().getUri().startsWith(PATH_UI)) {
            return this.handleSwaggerUi(exc);
        }
        return this.handleOverviewOpenAPIDoc(exc);
    }

    private Outcome handleOverviewOpenAPIDoc(Exchange exc) throws JsonProcessingException, MalformedURLException, URISyntaxException {
        Matcher m = patternMeta.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            if (this.acceptsHtmlExplicit(exc)) {
                return this.returnHtmlOverview(exc);
            }
            return this.returnJsonOverview(exc);
        }
        String id = m.group(1);
        OpenAPIRecord rec = this.apis.get(id);
        if (rec == null) {
            return this.returnNoFound(exc, id);
        }
        return this.returnOpenApiAsYaml(exc, rec);
    }

    private Outcome returnJsonOverview(Exchange exc) throws JsonProcessingException {
        exc.setResponse(Response.ok().contentType("application/json").body(this.ow.writeValueAsBytes((Object)this.createDictionaryOfAPIs())).build());
        return Outcome.RETURN;
    }

    private Outcome returnHtmlOverview(Exchange exc) {
        exc.setResponse(Response.ok().contentType(HTML_UTF_8).body(this.renderOverviewTemplate()).build());
        return Outcome.RETURN;
    }

    private Outcome returnNoFound(Exchange exc, String id) {
        exc.setResponse(Response.notFound().contentType("application/json").body(Utils.createErrorMessage(String.format("OpenAPI document with the id '%s' not found.", id))).build());
        return Outcome.RETURN;
    }

    private Outcome returnOpenApiAsYaml(Exchange exc, OpenAPIRecord rec) throws JsonProcessingException, MalformedURLException, URISyntaxException {
        this.rewriteOpenAPIaccordingToRequest(exc, rec);
        exc.setResponse(Response.ok().contentType("application/x-yaml").body(this.omYaml.writeValueAsBytes((Object)rec.node)).build());
        return Outcome.RETURN;
    }

    protected void rewriteOpenAPIaccordingToRequest(Exchange exc, OpenAPIRecord rec) throws MalformedURLException, URISyntaxException {
        if (rec.node.get("servers") == null) {
            return;
        }
        for (JsonNode server : rec.node.get("servers")) {
            ((ObjectNode)server).put("url", this.rewriteServerNode(exc, server));
        }
    }

    private String rewriteServerNode(Exchange exc, JsonNode server) throws MalformedURLException, URISyntaxException {
        return UriUtil.rewrite(this.router.getUriFactory(), server.get("url").asText(), this.getProtocol(exc), exc.getOriginalHostHeaderHost(), Integer.parseInt(exc.getOriginalHostHeaderPort()));
    }

    private String getProtocol(Exchange exc) {
        if (exc.getRule().getSslInboundContext() == null) {
            return "http";
        }
        return "https";
    }

    private Outcome handleSwaggerUi(Exchange exc) {
        Matcher m = patternUI.matcher(exc.getRequest().getUri());
        if (!m.matches()) {
            exc.setResponse(Response.ok().contentType("application/json").body("Please specify an Id").build());
            return Outcome.RETURN;
        }
        exc.setResponse(Response.ok().contentType(HTML_UTF_8).body(this.renderSwaggerUITemplate(m.group(1))).build());
        return Outcome.RETURN;
    }

    private String renderOverviewTemplate() {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("apis", this.apis);
        tempCtx.put("pathUi", PATH_UI);
        tempCtx.put("path", PATH);
        tempCtx.put("uriFactory", this.router.getUriFactory());
        return this.apiOverviewHtmlTemplate.make(tempCtx).toString();
    }

    private String renderSwaggerUITemplate(String id) {
        HashMap<String, Object> tempCtx = new HashMap<String, Object>();
        tempCtx.put("openApiUrl", "/api-doc/" + id);
        tempCtx.put("openApiTitle", this.apis.get((Object)id).api.getInfo().getTitle());
        return this.swaggerUiHtmlTemplate.make(tempCtx).toString();
    }

    private ObjectNode createDictionaryOfAPIs() {
        ObjectNode top = this.om.createObjectNode();
        for (Map.Entry<String, OpenAPIRecord> e : this.apis.entrySet()) {
            ObjectNode apiDetails = top.putObject(e.getKey());
            apiDetails.put("openapi", e.getValue().node.get("openapi").asText());
            apiDetails.put("title", e.getValue().node.get("info").get("title").asText());
            apiDetails.put("version", e.getValue().node.get("info").get("version").asText());
            apiDetails.put("openapi_link", "/api-doc/" + e.getKey());
            apiDetails.put("ui_link", "/api-doc/ui/" + e.getKey());
        }
        return top;
    }

    private boolean acceptsHtmlExplicit(Exchange exc) {
        if (exc.getRequest().getHeader().getAccept() == null) {
            return false;
        }
        return exc.getRequest().getHeader().getAccept().contains("html");
    }
}

