/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.openapi.util.OpenAPIUtil;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.FileUtil;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIRecordFactory {
    private static final Logger log = LoggerFactory.getLogger((String)OpenAPIRecordFactory.class.getName());
    private final ObjectMapper omYaml = ObjectMapperFactory.createYaml();
    private Router router;

    public OpenAPIRecordFactory(Router router) {
        this.router = router;
    }

    public Map<String, OpenAPIRecord> create(Collection<OpenAPIProxy.Spec> specs) throws IOException {
        LinkedHashMap<String, OpenAPIRecord> apiRecords = new LinkedHashMap<String, OpenAPIRecord>();
        for (OpenAPIProxy.Spec spec : specs) {
            this.addOpenApisFromLocation(apiRecords, spec);
            this.addOpenApisFromDirectory(apiRecords, spec);
        }
        return apiRecords;
    }

    private void addOpenApisFromDirectory(Map<String, OpenAPIRecord> apiRecords, OpenAPIProxy.Spec spec) throws IOException {
        if (spec.dir == null) {
            return;
        }
        log.info("Parsing specs from dir " + spec.dir);
        File[] openAPIFiles = this.getOpenAPIFiles(spec.dir);
        if (openAPIFiles == null) {
            log.warn(String.format("Directory %s does not contain any OpenAPI documents.", spec.dir));
            return;
        }
        for (File file : openAPIFiles) {
            log.info("Parsing spec " + file);
            OpenAPIRecord rec = this.create(spec, file);
            apiRecords.put(this.getUniqueId(apiRecords, rec), rec);
        }
    }

    private void addOpenApisFromLocation(Map<String, OpenAPIRecord> apiRecords, OpenAPIProxy.Spec spec) throws IOException {
        if (spec.location == null) {
            return;
        }
        log.info("Parsing spec " + spec.location);
        apiRecords.put(this.getUniqueId(apiRecords, this.create(spec)), this.create(spec));
    }

    private String getUniqueId(Map<String, OpenAPIRecord> apiRecords, OpenAPIRecord rec) {
        Object id = OpenAPIUtil.getIdFromAPI(rec.api);
        if (apiRecords.get(id) != null) {
            log.warn("There are multiple OpenAPI documents with the id {}. The id is computed from the title {} and version {}. Please make sure that the documents are different or use the x-membrane-id field.", new Object[]{id, rec.api.getInfo().getTitle(), rec.api.getInfo().getVersion()});
            id = (String)id + "-0";
            log.warn("Changing the id to {} in order to make them unique.", id);
        }
        return id;
    }

    private OpenAPIRecord create(OpenAPIProxy.Spec spec) throws IOException {
        OpenAPIRecord record = new OpenAPIRecord(this.getOpenAPI(this.router, spec), this.getSpec(this.router, spec));
        this.setExtentsionOnAPI(spec, record.api);
        return record;
    }

    private OpenAPIRecord create(OpenAPIProxy.Spec spec, File file) throws IOException {
        OpenAPIRecord record = new OpenAPIRecord(this.parseFileAsOpenAPI(file), this.getSpec(file));
        this.setExtentsionOnAPI(spec, record.api);
        return record;
    }

    private OpenAPI getOpenAPI(Router router, OpenAPIProxy.Spec spec) throws ResourceRetrievalException {
        return new OpenAPIParser().readContents(FileUtil.readInputStream(this.getInputStreamForLocation(router, spec.location)), null, null).getOpenAPI();
    }

    private OpenAPI parseFileAsOpenAPI(File oaFile) throws FileNotFoundException {
        return new OpenAPIParser().readContents(FileUtil.readInputStream(new FileInputStream(oaFile)), null, null).getOpenAPI();
    }

    private InputStream getInputStreamForLocation(Router router, String location) throws ResourceRetrievalException {
        return router.getResolverMap().resolve(ResolverMap.combine(router.getBaseLocation(), location));
    }

    private JsonNode getSpec(Router router, OpenAPIProxy.Spec spec) throws IOException {
        return this.omYaml.readTree(this.getInputStreamForLocation(router, spec.location));
    }

    private JsonNode getSpec(File file) throws IOException {
        return this.omYaml.readTree(file);
    }

    private void setExtentsionOnAPI(OpenAPIProxy.Spec spec, OpenAPI api) {
        if (api.getExtensions() == null) {
            api.setExtensions(new HashMap());
        }
        api.getExtensions().put("x-membrane-validation", this.updateExtension(this.getXValidationExtension(api), spec));
    }

    private Map<String, Object> getXValidationExtension(OpenAPI api) {
        if (api.getExtensions().get("x-membrane-validation") != null) {
            return (Map)api.getExtensions().get("x-membrane-validation");
        }
        HashMap<String, Object> extension = new HashMap<String, Object>();
        extension.put("requests", false);
        extension.put("responses", false);
        extension.put("details", true);
        return extension;
    }

    private Map<String, Object> updateExtension(Map<String, Object> extension, OpenAPIProxy.Spec spec) {
        if (spec.validationDetails != OpenAPIProxy.Spec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("details", this.toYesNo(spec.validationDetails));
        }
        if (spec.validateRequests != OpenAPIProxy.Spec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("requests", this.toYesNo(spec.validateRequests));
        }
        if (spec.validateResponses != OpenAPIProxy.Spec.YesNoOpenAPIOption.ASINOPENAPI) {
            extension.put("responses", this.toYesNo(spec.validateResponses));
        }
        extension.putIfAbsent("requests", false);
        extension.putIfAbsent("responses", false);
        return extension;
    }

    private boolean toYesNo(OpenAPIProxy.Spec.YesNoOpenAPIOption option) {
        return option == OpenAPIProxy.Spec.YesNoOpenAPIOption.YES;
    }

    private File[] getOpenAPIFiles(String dir) {
        return new File(dir).listFiles((d, name) -> name.endsWith(".yml") || name.endsWith(".yaml") || name.endsWith(".json"));
    }
}

