/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.serviceproxy;

import com.predic8.membrane.core.openapi.validators.ValidationContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ValidationStatsKey {
    public String method;
    public String path;
    public String uriTemplate;
    public String schemaType;
    public String complexType;
    public String validatedEntityType;
    public String validatedEntity;
    public String jsonpointer;
    private final Map<String, String> labels;

    ValidationStatsKey(ValidationContext vc) {
        this.method = vc.getMethod();
        this.path = vc.getPath();
        this.uriTemplate = vc.getUriTemplate();
        this.schemaType = vc.getSchemaType();
        this.complexType = vc.getComplexType();
        this.validatedEntityType = vc.getValidatedEntityType().name();
        this.validatedEntity = vc.getValidatedEntity();
        this.jsonpointer = vc.getJSONpointer();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("method", this.method);
        labels.put("path", this.path);
        labels.put("uritemplate", this.uriTemplate);
        labels.put("schematype", this.schemaType);
        labels.put("complextype", this.complexType);
        labels.put("entitytype", this.validatedEntityType);
        labels.put("entity", this.validatedEntity);
        labels.put("jsonpointer", this.jsonpointer);
        this.labels = Collections.unmodifiableMap(labels);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationStatsKey that = (ValidationStatsKey)o;
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.uriTemplate != null ? !this.uriTemplate.equals(that.uriTemplate) : that.uriTemplate != null) {
            return false;
        }
        if (this.schemaType != null ? !this.schemaType.equals(that.schemaType) : that.schemaType != null) {
            return false;
        }
        if (this.complexType != null ? !this.complexType.equals(that.complexType) : that.complexType != null) {
            return false;
        }
        if (!this.validatedEntityType.equals(that.validatedEntityType)) {
            return false;
        }
        if (this.validatedEntity != null ? !this.validatedEntity.equals(that.validatedEntity) : that.validatedEntity != null) {
            return false;
        }
        return this.jsonpointer != null ? this.jsonpointer.equals(that.jsonpointer) : that.jsonpointer == null;
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.uriTemplate != null ? this.uriTemplate.hashCode() : 0);
        result = 31 * result + (this.schemaType != null ? this.schemaType.hashCode() : 0);
        result = 31 * result + (this.complexType != null ? this.complexType.hashCode() : 0);
        result = 31 * result + this.validatedEntityType.hashCode();
        result = 31 * result + (this.validatedEntity != null ? this.validatedEntity.hashCode() : 0);
        result = 31 * result + (this.jsonpointer != null ? this.jsonpointer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ValidationStatsKey{method='" + this.method + "', path='" + this.path + "', uriTemplate='" + this.uriTemplate + "', schemaType='" + this.schemaType + "', complexType='" + this.complexType + "', validatedEntityType='" + this.validatedEntityType + "', validatedEntity='" + this.validatedEntity + "', jsonpointer='" + this.jsonpointer + "'}";
    }
}

