/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.predic8.membrane.core.openapi.util.PathDoesNotMatchException;
import com.predic8.membrane.core.openapi.util.UriUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTemplateMatcher {
    private static final Pattern pathParameterNamePattern = Pattern.compile("\\{(.*?)}");

    public Map<String, String> match(String template, String uri) throws PathDoesNotMatchException {
        Matcher matcher = Pattern.compile(this.escapeSlash(this.prepareRegex(template))).matcher(UriUtil.trimQueryString(uri));
        List<String> parameterNames = this.getPathParameterNames(template);
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                pathParameters.put(parameterNames.get(i - 1), matcher.group(i));
            }
        }
        if (!matcher.matches()) {
            throw new PathDoesNotMatchException();
        }
        return pathParameters;
    }

    public String prepareRegex(String uriTemplate) {
        return uriTemplate.replaceAll("\\{(.*?)}", "(.*)");
    }

    public String escapeSlash(String s) {
        return s.replaceAll("/", "\\\\/");
    }

    public List<String> getPathParameterNames(String uriTemplate) {
        Matcher matcher = pathParameterNamePattern.matcher(uriTemplate);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                variables.add(matcher.group(i));
            }
        }
        return variables;
    }
}

