/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.util;

import com.predic8.membrane.core.util.URIFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class UriUtil {
    public static String normalizeUri(String s) {
        return s.replaceAll("/+", "/");
    }

    public static String trimQueryString(String path) {
        int idx = path.indexOf(63);
        if (idx == -1) {
            return path;
        }
        return path.substring(0, path.indexOf(63));
    }

    public static Map<String, String> parseQueryString(String url) {
        int idxQM = url.indexOf(63);
        if (idxQM == -1) {
            return new HashMap<String, String>();
        }
        String qs = url.substring(idxQM + 1);
        if (qs.length() == 0) {
            return new HashMap<String, String>();
        }
        return UriUtil.splitQueryString(qs);
    }

    private static Map<String, String> splitQueryString(String qs) {
        String[] pairs;
        HashMap<String, String> qparams = new HashMap<String, String>();
        for (String pair : pairs = qs.split("&")) {
            String[] kv = pair.split("=");
            qparams.put(kv[0], kv[1]);
        }
        return qparams;
    }

    public static String getUrlWithoutPath(URL url) {
        StringBuilder urlWithoutPath = new StringBuilder();
        if (url.getProtocol() != null) {
            urlWithoutPath.append(url.getProtocol()).append("://");
        }
        if (url.getHost() != null) {
            urlWithoutPath.append(url.getHost());
        }
        urlWithoutPath.append(UriUtil.getPortString(url));
        return urlWithoutPath.toString();
    }

    private static String getPortString(URL url) {
        if (url.getPort() == 80 && url.getProtocol().equals("http")) {
            return "";
        }
        if (url.getPort() == 443 && url.getProtocol().equals("https")) {
            return "";
        }
        if (url.getPort() == -1) {
            return "";
        }
        return ":" + url.getPort();
    }

    public static String rewrite(URIFactory uriFactory, String url, String scheme, String host, int port) throws MalformedURLException, URISyntaxException {
        String path;
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(host);
        if (UriUtil.nonDefaultPort(scheme, port)) {
            sb.append(":");
            sb.append(port);
        }
        if ((path = UriUtil.getPathFromURL(uriFactory, url)) != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    private static boolean nonDefaultPort(String scheme, int port) {
        return !(port == 80 && scheme.equals("http") || port == 443 && scheme.equals("https"));
    }

    public static String getPathFromURL(URIFactory factory, String str) throws URISyntaxException {
        return factory.create(str).getPath();
    }
}

