/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.openapi.model.Message;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;

public class AbstractBodyValidator<T> {
    protected OpenAPI api;
    protected ValidationErrors errors = new ValidationErrors();

    public AbstractBodyValidator(OpenAPI api) {
        this.api = api;
    }

    protected void validateBodyAccordingToMediaType(ValidationContext ctx, String mediaType, MediaType mediaTypeObj, Message<T> message, int statusCode) {
        if (MimeType.APPLICATION_JSON_CONTENT_TYPE.match(mediaType)) {
            if (mediaTypeObj.getSchema().get$ref() != null) {
                ctx.schemaType(mediaTypeObj.getSchema().get$ref());
            }
            this.errors.add(new SchemaValidator(this.api, mediaTypeObj.getSchema()).validate(ctx.statusCode(statusCode), message.getBody()));
        } else if (MimeType.isXML(mediaType)) {
            this.errors.add(ctx.statusCode(statusCode), "Validation of XML messages is not implemented yet!");
        } else if (MimeType.isWWWFormUrlEncoded(mediaType)) {
            this.errors.add(ctx.statusCode(statusCode), "Validation of 'application/x-www-form-urlencoded' messages is not implemented yet!");
        }
    }
}

