/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;

public class AllOfValidator {
    private final OpenAPI api;
    private final Schema schema;

    public AllOfValidator(OpenAPI api, Schema schema) {
        this.api = api;
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        ValidationErrors errors = new ValidationErrors();
        List allOfSchemas = this.schema.getAllOf();
        allOfSchemas.forEach(schema -> errors.add(new SchemaValidator(this.api, (Schema)schema).validate(ctx, obj)));
        if (errors.size() > 0) {
            errors.add(ctx, "One of the subschemas of allOf is not valid.");
        }
        return errors;
    }
}

