/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnyOfValidator {
    private final OpenAPI api;
    private final Schema schema;

    public AnyOfValidator(OpenAPI api, Schema schema) {
        this.api = api;
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        AtomicBoolean oneIsValid = new AtomicBoolean();
        this.schema.getAnyOf().forEach(schema -> {
            if (!Utils.areThereErrors(new SchemaValidator(this.api, (Schema)schema).validate(ctx, obj))) {
                oneIsValid.set(true);
            }
        });
        if (oneIsValid.get()) {
            return null;
        }
        return ValidationErrors.create(ctx, "None of the subschemas of anyOf was true.");
    }
}

