/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashSet;

public class ArrayValidator
implements IJSONSchemaValidator {
    private final Schema schema;
    private final OpenAPI api;

    public ArrayValidator(OpenAPI api, Schema schema) {
        this.api = api;
        this.schema = schema;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object value) {
        ValidationErrors errors = new ValidationErrors();
        Schema itemsSchema = this.schema.getItems();
        JsonNode node = (JsonNode)value;
        if (itemsSchema != null) {
            for (int i = 0; i < node.size(); ++i) {
                errors.add(new SchemaValidator(this.api, itemsSchema).validate(ctx.addJSONpointerSegment(Integer.toString(i)), node.get(i)));
            }
        }
        if (this.schema.getPrefixItems() != null) {
            this.schema.getPrefixItems().forEach(o -> System.out.println("o = " + o));
        }
        if (this.schema.getMinItems() != null && node.size() < this.schema.getMinItems()) {
            errors.add(ctx, String.format("Array has %d items. This is less then minItems of %d.", node.size(), this.schema.getMinItems()));
        }
        if (this.schema.getMaxItems() != null && node.size() > this.schema.getMaxItems()) {
            errors.add(ctx, String.format("Array has %d items. This is more then maxItems of %d.", node.size(), this.schema.getMaxItems()));
        }
        errors.add(this.validateUniqueItems(ctx, node));
        return errors;
    }

    private ValidationErrors validateUniqueItems(ValidationContext ctx, JsonNode node) {
        if (this.schema.getUniqueItems() == null || !this.schema.getUniqueItems().booleanValue()) {
            return null;
        }
        HashSet<JsonNode> itemValues = new HashSet<JsonNode>();
        ArrayList<String> moreThanOnce = new ArrayList<String>();
        for (int i = 0; i < node.size(); ++i) {
            if (itemValues.contains(node.get(i))) {
                moreThanOnce.add(node.get(i).toString());
            }
            itemValues.add(node.get(i));
        }
        if (moreThanOnce.size() > 0) {
            return ValidationErrors.create(ctx, String.format("Array with restriction uniqueItems has the not unique values %s.", Utils.joinByComma(moreThanOnce)));
        }
        return null;
    }
}

