/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;

public class BooleanValidator
implements IJSONSchemaValidator {
    @Override
    public ValidationErrors validate(ValidationContext ctx, Object value) {
        ValidationErrors errors = new ValidationErrors();
        if (value instanceof BooleanNode) {
            return errors;
        }
        String str = "";
        if (value instanceof TextNode) {
            str = ((TextNode)value).asText();
        } else if (value instanceof String) {
            str = (String)value;
        }
        if (str.equals("true") || str.equals("false")) {
            return errors;
        }
        errors.add(ctx, String.format("Value '%s' is not a boolean (true/false).", value));
        return errors;
    }
}

