/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;

public class NumberRestrictionValidator {
    private final Schema schema;

    public NumberRestrictionValidator(Schema schema) {
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        BigDecimal multiplesOf;
        BigDecimal[] remainder;
        ctx = ctx.schemaType(this.schema.getType());
        if (obj instanceof ObjectNode) {
            return null;
        }
        if (obj instanceof ArrayNode) {
            return null;
        }
        if (obj instanceof BooleanNode) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        try {
            if (obj instanceof JsonNode) {
                obj = new BigDecimal(((JsonNode)obj).asText());
            } else if (obj instanceof String) {
                obj = BigDecimal.valueOf(Double.parseDouble((String)obj));
            }
        }
        catch (NumberFormatException e) {
            return errors;
        }
        BigDecimal value = (BigDecimal)obj;
        if (this.schema.getMinimum() != null) {
            if (this.schema.getMinimum().compareTo(value) > 0) {
                errors.add(new ValidationError(ctx, value + " is smaller than the minimum of " + this.schema.getMinimum()));
            }
            if (this.isExlusiveMinimum() && this.schema.getMinimum().compareTo(value) == 0) {
                errors.add(new ValidationError(ctx, String.format("The value of %s should be greater than the exclusive minimum.", this.schema.getMinimum())));
            }
        }
        if (this.schema.getMaximum() != null) {
            if (this.schema.getMaximum().compareTo(value) < 0) {
                errors.add(new ValidationError(ctx, value + " is greater than the maximum of " + this.schema.getMaximum()));
            }
            if (this.isExlusiveMaximum() && this.schema.getMaximum().compareTo(value) == 0) {
                errors.add(new ValidationError(ctx, String.format("The value of %s should be less than the exclusive maximum.", this.schema.getMinimum())));
            }
        }
        if (this.schema.getMultipleOf() != null && (remainder = value.divideAndRemainder(multiplesOf = this.schema.getMultipleOf()))[1].intValue() != 0) {
            errors.add(ctx, String.format("Value %d is not a multiple of %d.", value.intValue(), multiplesOf.intValue()));
        }
        return errors;
    }

    private boolean isExlusiveMinimum() {
        return this.schema.getExclusiveMinimum() != null && this.schema.getExclusiveMinimum() != false;
    }

    private boolean isExlusiveMaximum() {
        return this.schema.getExclusiveMaximum() != null && this.schema.getExclusiveMaximum() != false;
    }
}

