/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import java.math.BigDecimal;

public class NumberValidator
implements IJSONSchemaValidator {
    @Override
    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        try {
            if (obj instanceof JsonNode) {
                new BigDecimal(((JsonNode)obj).asText());
            } else if (obj instanceof String) {
                Double.parseDouble((String)obj);
            }
        }
        catch (NumberFormatException e) {
            return ValidationErrors.create(ctx.schemaType("number"), String.format("%s is not a number.", obj));
        }
        return null;
    }
}

