/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.List;

public class PathParametersValidator {
    OpenAPI api;
    ValidationErrors errors = new ValidationErrors();

    public PathParametersValidator(OpenAPI api) {
        this.api = api;
    }

    public ValidationErrors validatePathParameters(ValidationContext ctx, Request req, List<Parameter> schemaParameters) {
        if (schemaParameters == null || req.getPathParameters().size() == 0) {
            return null;
        }
        schemaParameters.stream().filter(this::isPathParameter).forEach(parameter -> {
            String value = req.getPathParameters().get(parameter.getName());
            if (value == null) {
                throw new RuntimeException("Should not happen!");
            }
            this.errors.add(new SchemaValidator(this.api, parameter.getSchema()).validate(ctx.validatedEntityType(ValidationContext.ValidatedEntityType.PATH_PARAMETER).validatedEntity(parameter.getName()).path(req.getPath()).statusCode(400), value));
        });
        return this.errors;
    }

    private boolean isPathParameter(Parameter p) {
        return p instanceof PathParameter;
    }
}

