/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.validators.SchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryParameterValidator {
    OpenAPI api;
    PathItem pathItem;

    public QueryParameterValidator(OpenAPI api, PathItem pathItem) {
        this.api = api;
        this.pathItem = pathItem;
    }

    ValidationErrors validateQueryParameters(ValidationContext ctx, Request request, Operation operation) {
        ValidationErrors errors = new ValidationErrors();
        String query = new URIFactory().createWithoutException(request.getPath()).getQuery();
        Map<String, String> qparams = this.getQueryParams(query);
        this.getAllParameterSchemas(operation).forEach(param -> {
            if (!(param instanceof QueryParameter)) {
                return;
            }
            errors.add(this.validateQueryParameter(ctx.validatedEntity(param.getName()).validatedEntityType(ValidationContext.ValidatedEntityType.QUERY_PARAMETER), qparams, (Parameter)param));
            qparams.remove(param.getName());
        });
        errors.add(this.checkForAdditionalQueryParameters(ctx, qparams));
        return errors;
    }

    private Map<String, String> getQueryParams(String query) {
        if (query != null) {
            return URLParamUtil.parseQueryString(query, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        }
        return new HashMap<String, String>();
    }

    private List<Parameter> getAllParameterSchemas(Operation operation) {
        return QueryParameterValidator.concat(this.pathItem.getParameters(), operation.getParameters());
    }

    private static List<Parameter> concat(List<Parameter> l1, List<Parameter> l2) {
        if (l1 == null) {
            return Objects.requireNonNullElseGet(l2, ArrayList::new);
        }
        if (l2 != null) {
            l1.addAll(l2);
        }
        return l1;
    }

    private ValidationErrors validateQueryParameter(ValidationContext ctx, Map<String, String> qparams, Parameter param) {
        ValidationErrors errors = new ValidationErrors();
        String value = qparams.get(param.getName());
        if (value != null) {
            errors.add(new SchemaValidator(this.api, param.getSchema()).validate(ctx.statusCode(400).validatedEntity(param.getName()).validatedEntityType(ValidationContext.ValidatedEntityType.QUERY_PARAMETER), value));
        } else if (param.getRequired().booleanValue()) {
            errors.add(ctx, String.format("Missing required query parameter %s.", param.getName()));
        }
        return errors;
    }

    private ValidationError checkForAdditionalQueryParameters(ValidationContext ctx, Map<String, String> qparams) {
        if (qparams.size() > 0) {
            return new ValidationError(ctx.validatedEntityType(ValidationContext.ValidatedEntityType.QUERY_PARAMETER), "There are query parameters that are not supported by the API: " + qparams.keySet());
        }
        return null;
    }
}

