/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.AbstractBodyValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;

public class RequestBodyValidator
extends AbstractBodyValidator<Request> {
    public RequestBodyValidator(OpenAPI api) {
        super(api);
    }

    ValidationErrors validateRequestBody(ValidationContext ctx, Operation operation, Request request) {
        if (operation.getRequestBody() == null) {
            if (!request.hasBody()) {
                return this.errors;
            }
            return this.errors.add(ctx.statusCode(400), "Request has a body although it should't.");
        }
        if (operation.getRequestBody().getContent() != null) {
            this.validateRequestBodyInternal(ctx, request, operation.getRequestBody());
        } else {
            String ref = operation.getRequestBody().get$ref();
            if (ref != null) {
                this.validateRequestBodyInternal(ctx, request, this.getRequestBodyFromSchema(ref));
            } else {
                throw new RuntimeException("Should not happen!");
            }
        }
        return this.errors;
    }

    private RequestBody getRequestBodyFromSchema(String ref) {
        return (RequestBody)this.api.getComponents().getRequestBodies().get(Utils.getComponentLocalNameFromRef(ref));
    }

    private void validateRequestBodyInternal(ValidationContext ctx, Request request, RequestBody requestBody) {
        requestBody.getContent().forEach((s, mediaType) -> this.validateMediaType(ctx, (String)s, (MediaType)mediaType, request));
    }

    private void validateMediaType(ValidationContext ctx, String mediaType, MediaType mediaTypeObj, Request request) {
        if (request.getMediaType() == null) {
            this.errors.add(ctx.statusCode(400), "The request has a body, but no Content-Type header.");
            return;
        }
        if (!request.isOfMediaType(mediaType)) {
            this.errors.add(ctx.statusCode(415).validatedEntityType(ValidationContext.ValidatedEntityType.MEDIA_TYPE).validatedEntity(request.getMediaType().toString()), String.format("Request has mediatype %s instead of the expected type %s.", request.getMediaType(), mediaType));
            return;
        }
        this.validateBodyAccordingToMediaType(ctx, mediaType, mediaTypeObj, request, 400);
    }
}

