/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Response;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.AbstractBodyValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import jakarta.mail.internet.ParseException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseBodyValidator
extends AbstractBodyValidator<Response> {
    public ResponseBodyValidator(OpenAPI api) {
        super(api);
    }

    ValidationErrors validateResponseBody(ValidationContext ctx, Response response, Operation operation) {
        if (operation.getResponses() == null) {
            throw new RuntimeException("An operation should always have at least one response declared.");
        }
        AtomicBoolean foundMatchingResponse = new AtomicBoolean();
        operation.getResponses().forEach((statusCode, responseSpec) -> {
            if (response.sameStatusCode((String)statusCode)) {
                foundMatchingResponse.set(true);
                if (responseSpec.getContent() != null) {
                    this.validateResponseBodyInternal(ctx, response, (ApiResponse)responseSpec);
                } else {
                    String ref = responseSpec.get$ref();
                    if (ref != null) {
                        this.validateResponseBodyInternal(ctx, response, (ApiResponse)this.api.getComponents().getResponses().get(Utils.getComponentLocalNameFromRef(ref)));
                    } else if (response.hasBody()) {
                        this.errors.add(ctx.statusCode(500), "Response should't have a body. There is no content described in the API specification.");
                    }
                }
            }
        });
        if (!foundMatchingResponse.get()) {
            this.errors.add(ctx.statusCode(500), String.format("Server returned a status code of %d but allowed are only %s", response.getStatusCode(), Utils.joinByComma(operation.getResponses().keySet())));
        }
        return this.errors;
    }

    private void validateResponseBodyInternal(ValidationContext ctx, Response response, ApiResponse apiResponse) {
        if (apiResponse.getContent() == null) {
            return;
        }
        apiResponse.getContent().forEach((s, mediaType) -> {
            try {
                this.validateMediaType(ctx, (String)s, (MediaType)mediaType, response);
            }
            catch (ParseException e) {
                this.errors.add(ctx.statusCode(500), String.format("Validating error. Something is wrong with the mediaType %s", mediaType));
            }
        });
    }

    private void validateMediaType(ValidationContext ctx, String mediaType, MediaType mediaTypeObj, Response response) throws ParseException {
        if (response.getMediaType() == null) {
            this.errors.add(ctx.statusCode(500), "The response has a body, but no Content-Type header.");
            return;
        }
        if (!response.isOfMediaType(mediaType)) {
            this.errors.add(ctx.statusCode(500).validatedEntityType(ValidationContext.ValidatedEntityType.MEDIA_TYPE).validatedEntity(response.getMediaType().toString()), String.format("Response with status code %d has mediatype %s instead of the expected type %s.", response.getStatusCode(), response.getMediaType(), mediaType));
            return;
        }
        this.validateBodyAccordingToMediaType(ctx, mediaType, mediaTypeObj, response, 500);
    }
}

