/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.util.SchemaUtil;
import com.predic8.membrane.core.openapi.validators.AllOfValidator;
import com.predic8.membrane.core.openapi.validators.AnyOfValidator;
import com.predic8.membrane.core.openapi.validators.ArrayValidator;
import com.predic8.membrane.core.openapi.validators.BooleanValidator;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.IntegerValidator;
import com.predic8.membrane.core.openapi.validators.NotValidator;
import com.predic8.membrane.core.openapi.validators.NumberRestrictionValidator;
import com.predic8.membrane.core.openapi.validators.NumberValidator;
import com.predic8.membrane.core.openapi.validators.ObjectValidator;
import com.predic8.membrane.core.openapi.validators.OneOfValidator;
import com.predic8.membrane.core.openapi.validators.StringRestrictionValidator;
import com.predic8.membrane.core.openapi.validators.StringValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator
implements IJSONSchemaValidator {
    private static Logger log = LoggerFactory.getLogger((String)SchemaValidator.class.getName());
    private final ObjectMapper om = new ObjectMapper();
    private Schema schema;
    private final OpenAPI api;

    public SchemaValidator(OpenAPI api, Schema schema) {
        if (schema == null) {
            throw new RuntimeException("Should not happen!");
        }
        this.schema = schema;
        this.api = api;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        Object value;
        ValidationErrors errors = new ValidationErrors();
        if (obj == null) {
            return errors.add(ctx, "Got null to validate!");
        }
        try {
            value = this.resolveValueAndParseJSON(obj);
        }
        catch (IOException e) {
            log.warn("Cannot parse body. " + e);
            return errors.add(new ValidationError(ctx.statusCode(400).validatedEntityType(ValidationContext.ValidatedEntityType.BODY).validatedEntity("REQUEST"), "Request body cannot be parsed as JSON"));
        }
        if (this.schema.getAllOf() != null) {
            errors.add(new AllOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getAnyOf() != null) {
            errors.add(new AnyOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getOneOf() != null) {
            errors.add(new OneOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getNot() != null) {
            errors.add(new NotValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.get$ref() != null && !SchemaUtil.getSchemaNameFromRef(this.schema).equals(ctx.getComplexType())) {
            ctx = ctx.complexType(SchemaUtil.getSchemaNameFromRef(this.schema));
            this.schema = SchemaUtil.getSchemaFromRef(this.api, this.schema);
            if (this.schema == null) {
                throw new RuntimeException("Should not happen!");
            }
        }
        if (this.schema.getType() == null) {
            if ((value == null || value instanceof NullNode) && this.schema.getNullable().booleanValue()) {
                return ValidationErrors.create(ctx, "Value is null and no type is set.");
            }
        } else if ((value == null || value instanceof NullNode) && this.schema.getNullable().booleanValue()) {
            return errors;
        }
        errors.add(new StringRestrictionValidator(this.schema).validate(ctx, value));
        errors.add(new NumberRestrictionValidator(this.schema).validate(ctx, value));
        errors.add(this.validateByType(ctx, value));
        return errors;
    }

    private ValidationErrors validateByType(ValidationContext ctx, Object value) {
        if (this.schema.getType() == null) {
            return null;
        }
        try {
            switch (this.schema.getType()) {
                case "number": {
                    return new NumberValidator().validate(ctx.schemaType("number"), value);
                }
                case "integer": {
                    return new IntegerValidator().validate(ctx.schemaType("integer"), value);
                }
                case "string": {
                    return new StringValidator(this.schema).validate(ctx.schemaType("string"), value);
                }
                case "boolean": {
                    return new BooleanValidator().validate(ctx.schemaType("boolean"), value);
                }
                case "array": {
                    return new ArrayValidator(this.api, this.schema).validate(ctx.schemaType("array"), value);
                }
                case "object": {
                    return new ObjectValidator(this.api, this.schema).validate(ctx.schemaType("object"), value);
                }
            }
            throw new RuntimeException("Should not happen! " + this.schema.getType());
        }
        catch (Exception e) {
            return ValidationErrors.create(ctx, String.format("%s is not of %s format.", value, this.schema.getType()));
        }
    }

    private Object resolveValueAndParseJSON(Object obj) throws IOException {
        if (obj instanceof Body) {
            return ((Body)obj).getJson();
        }
        if (obj instanceof InputStream) {
            throw new RuntimeException("InputStream!");
        }
        return obj;
    }
}

