/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.media.Schema;

public class StringRestrictionValidator {
    private final Schema schema;

    public StringRestrictionValidator(Schema schema) {
        this.schema = schema;
    }

    public ValidationErrors validate(ValidationContext ctx, Object value) {
        if (value == null) {
            return null;
        }
        ctx = ctx.schemaType(this.schema.getType());
        if (value instanceof ObjectNode) {
            return null;
        }
        if (value instanceof ArrayNode) {
            return null;
        }
        if (value instanceof IntNode) {
            return null;
        }
        if (value instanceof BooleanNode) {
            return null;
        }
        if (value instanceof DoubleNode) {
            return null;
        }
        if (value instanceof DecimalNode) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors();
        String str = this.getStringValue(value);
        if (this.isMaxlenExceeded(str)) {
            errors.add(new ValidationError(ctx.schemaType("string"), String.format("The string '%s' is %d characters long. MaxLength of %d is exceeded.", str, str.length(), this.schema.getMaxLength())));
        }
        if (this.isMinLenExceeded(str)) {
            errors.add(new ValidationError(ctx.schemaType("string"), String.format("The string '%s' is %d characters long. The length of the string is shorter than the minLength of %d.", str, str.length(), this.schema.getMinLength())));
        }
        return errors;
    }

    private boolean isMinLenExceeded(String str) {
        return this.schema.getMinLength() != null && str.length() < this.schema.getMinLength();
    }

    private boolean isMaxlenExceeded(String str) {
        return this.schema.getMaxLength() != null && str.length() > this.schema.getMaxLength();
    }

    private String getStringValue(Object value) {
        String str = null;
        if (value instanceof String) {
            str = (String)value;
        }
        if (value instanceof TextNode) {
            str = ((TextNode)value).asText();
        }
        return str;
    }
}

