/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.model.Request;

public class ValidationContext {
    private String method;
    private String path;
    private String uriTemplate;
    private String jsonPointer = "";
    private String schemaType;
    private String complexType;
    private ValidatedEntityType validatedEntityType;
    private String validatedEntity;
    private int statusCode;

    public static ValidationContext fromRequest(Request request) {
        ValidationContext ctx = new ValidationContext();
        ctx.method = request.getMethod();
        ctx.path = request.getPath();
        return ctx;
    }

    public ValidationContext(ValidationContext ctx) {
        this.method = ctx.method;
        this.path = ctx.path;
        this.uriTemplate = ctx.uriTemplate;
        this.jsonPointer = ctx.jsonPointer;
        this.schemaType = ctx.schemaType;
        this.complexType = ctx.complexType;
        this.validatedEntityType = ctx.validatedEntityType;
        this.validatedEntity = ctx.validatedEntity;
        this.statusCode = ctx.statusCode;
    }

    public ValidationContext() {
    }

    public static ValidationContext create() {
        return new ValidationContext();
    }

    public ValidationContext deepCopy() {
        return new ValidationContext(this);
    }

    public String getJSONpointer() {
        return this.jsonPointer;
    }

    public String getMethod() {
        return this.method;
    }

    public ValidatedEntityType getValidatedEntityType() {
        return this.validatedEntityType;
    }

    public String getValidatedEntity() {
        return this.validatedEntity;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getComplexType() {
        return this.complexType;
    }

    public String getLocationForRequest() {
        return this.getLocation("REQUEST");
    }

    public String getLocationForResponse() {
        return this.getLocation("RESPONSE");
    }

    private String getLocation(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append("/");
        if (this.validatedEntityType.equals((Object)ValidatedEntityType.QUERY_PARAMETER)) {
            sb.append(this.validatedEntityType.name());
            this.appendValidatedEntity(sb);
        } else if (this.validatedEntityType.equals((Object)ValidatedEntityType.PATH_PARAMETER)) {
            sb.append(this.validatedEntityType.name());
            this.appendValidatedEntity(sb);
        } else if (this.validatedEntityType.equals((Object)ValidatedEntityType.MEDIA_TYPE)) {
            sb.append("HEADER/Content-Type");
        } else {
            sb.append(this.validatedEntityType.name());
            if (this.jsonPointer.length() > 0) {
                sb.append("#");
                sb.append(this.getJSONpointer());
            }
        }
        return sb.toString();
    }

    private void appendValidatedEntity(StringBuilder sb) {
        if (this.validatedEntity != null) {
            sb.append("/");
            sb.append(this.validatedEntity);
        }
    }

    public ValidationContext path(String path) {
        ValidationContext ctx = this.deepCopy();
        ctx.path = path;
        return ctx;
    }

    public ValidationContext method(String method) {
        ValidationContext ctx = this.deepCopy();
        ctx.method = method;
        return ctx;
    }

    public ValidationContext uriTemplate(String uriTemplate) {
        ValidationContext ctx = this.deepCopy();
        ctx.uriTemplate = uriTemplate;
        return ctx;
    }

    public ValidationContext validatedEntityType(ValidatedEntityType type) {
        ValidationContext ctx = this.deepCopy();
        ctx.validatedEntityType = type;
        return ctx;
    }

    public ValidationContext validatedEntity(String entity) {
        ValidationContext ctx = this.deepCopy();
        ctx.validatedEntity = entity;
        return ctx;
    }

    public ValidationContext statusCode(int statusCode) {
        ValidationContext ctx = this.deepCopy();
        ctx.statusCode = statusCode;
        return ctx;
    }

    public ValidationContext schemaType(String type) {
        ValidationContext ctx = this.deepCopy();
        ctx.schemaType = type;
        return ctx;
    }

    public ValidationContext complexType(String type) {
        ValidationContext ctx = this.deepCopy();
        ctx.complexType = type;
        return ctx;
    }

    public String getPath() {
        return this.path;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public ValidationContext addJSONpointerSegment(String segment) {
        ValidationContext ctx = this.deepCopy();
        ctx.jsonPointer = ctx.jsonPointer + "/" + segment;
        return ctx;
    }

    public String toString() {
        return "ValidationContext{method='" + this.method + "', path='" + this.path + "', uriTemplate='" + this.uriTemplate + "', xpointer='" + this.jsonPointer + "', schemaType='" + this.schemaType + "', complexType='" + this.complexType + "', validatedEntityType=" + this.validatedEntityType + ", validatedEntity='" + this.validatedEntity + "', statusCode=" + this.statusCode + "}";
    }

    public static enum ValidatedEntityType {
        PATH,
        METHOD,
        PATH_PARAMETER,
        QUERY_PARAMETER,
        BODY,
        FIELD,
        PROPERTY,
        MEDIA_TYPE;

    }
}

