/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ValidationErrors {
    private static final ObjectMapper om = new ObjectMapper();
    private final List<ValidationError> errors = new ArrayList<ValidationError>();

    public static ValidationErrors create(ValidationContext ctx, String message) {
        ValidationErrors ve = new ValidationErrors();
        ve.add(ctx, message);
        return ve;
    }

    public ValidationErrors add(ValidationError error) {
        if (error != null) {
            this.errors.add(error);
        }
        return this;
    }

    public void add(List<ValidationError> errors) {
        this.errors.addAll(errors);
    }

    public ValidationErrors add(ValidationErrors ve) {
        if (ve != null) {
            this.errors.addAll(ve.errors);
        }
        return this;
    }

    public ValidationErrors add(ValidationContext ctx, String message) {
        this.errors.add(new ValidationError(ctx, message));
        return this;
    }

    public int size() {
        return this.errors.size();
    }

    public ValidationError get(int i) {
        return this.errors.get(i);
    }

    public Stream<ValidationError> stream() {
        return this.errors.stream();
    }

    public int getConsolidatedStatusCode(int defaultValue) {
        return this.errors.stream().map(e -> e.getContext().getStatusCode()).reduce((code, acc) -> {
            if (acc == defaultValue) {
                return code;
            }
            return acc;
        }).orElse(defaultValue);
    }

    public byte[] getErrorMessage(Direction direction) {
        if (this.errors.size() == 0) {
            return "No validation errors!".getBytes();
        }
        Map<String, List<Map<String, Object>>> m = this.getValidationErrorsGroupedByLocation(direction);
        LinkedHashMap<String, Map<String, List<Map<String, Object>>>> wrapper = new LinkedHashMap<String, Map<String, List<Map<String, Object>>>>();
        ValidationContext ctx = this.errors.get(0).getContext();
        Utils.setFieldIfNotNull(wrapper, "method", ctx.getMethod());
        Utils.setFieldIfNotNull(wrapper, "uriTemplate", ctx.getUriTemplate());
        Utils.setFieldIfNotNull(wrapper, "path", ctx.getPath());
        wrapper.put("validationErrors", m);
        try {
            return om.writerWithDefaultPrettyPrinter().writeValueAsBytes(wrapper);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "Error!".getBytes();
        }
    }

    private Map<String, List<Map<String, Object>>> getValidationErrorsGroupedByLocation(Direction direction) {
        HashMap<String, List<Map<String, Object>>> m = new HashMap<String, List<Map<String, Object>>>();
        this.errors.forEach(ve -> {
            ArrayList<Map<String, Object>> ves = new ArrayList<Map<String, Object>>();
            ves.add(ve.getContentMap());
            m.merge(this.getLocationFor(direction, (ValidationError)ve), ves, (vesOld, vesNew) -> {
                vesOld.addAll(vesNew);
                return vesOld;
            });
        });
        return m;
    }

    private String getLocationFor(Direction direction, ValidationError ve) {
        if (direction.equals((Object)Direction.REQUEST)) {
            return ve.getContext().getLocationForRequest();
        }
        return ve.getContext().getLocationForResponse();
    }

    public String toString() {
        return "ValidationErrors{errors=" + this.errors + "}";
    }

    public static enum Direction {
        REQUEST,
        RESPONSE;

    }
}

