/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class FileSchemaResolver
implements SchemaResolver {
    WatchService watchService;
    ConcurrentHashMap<String, WatchKey> watchServiceForFile = new ConcurrentHashMap();
    ConcurrentHashMap<String, Consumer<InputStream>> watchedFiles = new ConcurrentHashMap();
    int fileWatchIntervalInSeconds = 1;
    Runnable fileWatchJob = new Runnable(){

        @Override
        public void run() {
            while (FileSchemaResolver.this.watchedFiles.size() > 0) {
                for (String url : FileSchemaResolver.this.watchServiceForFile.keySet()) {
                    WatchKey wk = FileSchemaResolver.this.watchServiceForFile.get(url);
                    List<WatchEvent<?>> events = wk.pollEvents();
                    for (WatchEvent<?> event : events) {
                        Path changedFile = (Path)event.context();
                        Path urlPath = Paths.get(url, new String[0]).getFileName();
                        if (!changedFile.toString().equals(urlPath.toString())) continue;
                        try {
                            Consumer<InputStream> inputStreamConsumer = FileSchemaResolver.this.watchedFiles.get(url);
                            FileSchemaResolver.this.watchServiceForFile.remove(url);
                            FileSchemaResolver.this.watchedFiles.remove(url);
                            inputStreamConsumer.call(FileSchemaResolver.this.resolve(url));
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    Thread.sleep(FileSchemaResolver.this.fileWatchIntervalInSeconds * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            FileSchemaResolver.this.fileWatcher = null;
        }
    };
    Thread fileWatcher = null;

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"file", null});
    }

    @Override
    public InputStream resolve(String url) throws ResourceRetrievalException {
        try {
            return new FileInputStream(new File(FileSchemaResolver.normalize(url)));
        }
        catch (FileNotFoundException e) {
            throw new ResourceRetrievalException(url, e);
        }
    }

    @Override
    public void observeChange(String url, Consumer<InputStream> consumer) throws ResourceRetrievalException {
        url = Paths.get(FileSchemaResolver.normalize(url), new String[0]).toAbsolutePath().toString();
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Path path = Paths.get(url, new String[0]).getParent();
        WatchKey watchKey = null;
        try {
            watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.watchServiceForFile.put(url, watchKey);
        this.watchedFiles.put(url, consumer);
        if (this.fileWatcher == null) {
            this.fileWatcher = new Thread(this.fileWatchJob);
        }
        if (!this.fileWatcher.isAlive()) {
            this.fileWatcher.start();
        }
    }

    public static String normalize(String uri) {
        if (((String)uri).startsWith("file:///")) {
            uri = ((String)uri).length() > 9 && ((String)uri).charAt(9) == '/' ? ((String)uri).charAt(8) + ":\\" + URLDecoder.decode(((String)uri).substring(9)) : "/" + URLDecoder.decode(((String)uri).substring(8));
        }
        if (((String)uri).startsWith("file://")) {
            uri = ((String)uri).length() > 8 && ((String)uri).charAt(8) == '/' ? ((String)uri).charAt(7) + ":\\" + URLDecoder.decode(((String)uri).substring(9)) : "/" + URLDecoder.decode(((String)uri).substring(7));
        }
        if (((String)uri).startsWith("file:")) {
            uri = URLDecoder.decode(((String)uri).substring(5));
        }
        return uri;
    }

    @Override
    public List<String> getChildren(String url) {
        String[] children = new File(FileSchemaResolver.normalize(url)).list();
        if (children == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(children.length);
        for (String child : children) {
            res.add(child);
        }
        return res;
    }

    @Override
    public long getTimestamp(String url) {
        return new File(FileSchemaResolver.normalize(url)).lastModified();
    }
}

