/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@MCElement(name="httpSchemaResolver")
public class HTTPSchemaResolver
implements SchemaResolver {
    private HttpClientFactory httpClientFactory;
    private ConcurrentHashMap<String, String> watchedUrlMd5s = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Consumer<InputStream>> consumerForUrls = new ConcurrentHashMap();
    int httpWatchIntervalInSeconds = 1;
    Thread httpWatcher = null;
    Runnable httpWatchJob = new Runnable(){

        @Override
        public void run() {
            MessageDigest md5 = null;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            HttpClient client = HTTPSchemaResolver.this.httpClientFactory.createClient(null);
            while (HTTPSchemaResolver.this.watchedUrlMd5s.size() > 0) {
                try {
                    for (String url : HTTPSchemaResolver.this.watchedUrlMd5s.keySet()) {
                        md5.reset();
                        Exchange exc = new Request.Builder().method("GET").url(HTTPSchemaResolver.this.uriFactory, url).header("User-Agent", "Membrane Service Proxy " + Constants.VERSION).buildExchange();
                        Response response = client.call(exc).getResponse();
                        if (response.getStatusCode() != 200) {
                            ResourceRetrievalException rde = new ResourceRetrievalException(url, response.getStatusCode());
                            throw rde;
                        }
                        String hash = new String(md5.digest(response.getBody().getContent()));
                        if (HTTPSchemaResolver.this.watchedUrlMd5s.get(url).equals("")) {
                            HTTPSchemaResolver.this.watchedUrlMd5s.put(url, hash);
                            continue;
                        }
                        if (hash.equals(HTTPSchemaResolver.this.watchedUrlMd5s.get(url))) continue;
                        Consumer<InputStream> inputStreamConsumer = HTTPSchemaResolver.this.consumerForUrls.get(url);
                        HTTPSchemaResolver.this.watchedUrlMd5s.remove(url);
                        HTTPSchemaResolver.this.consumerForUrls.remove(url);
                        inputStreamConsumer.call(response.getBodyAsStream());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(HTTPSchemaResolver.this.httpWatchIntervalInSeconds * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            HTTPSchemaResolver.this.httpWatcher = null;
        }
    };
    private HttpClientConfiguration httpClientConfig = new HttpClientConfiguration();
    private HttpClient httpClient;
    private URIFactory uriFactory = new URIFactory(false);

    public HTTPSchemaResolver(@Nullable HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            if (this.httpClientFactory == null) {
                this.httpClientFactory = new HttpClientFactory(null);
            }
            this.httpClient = this.httpClientFactory.createClient(this.httpClientConfig);
        }
        return this.httpClient;
    }

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"http", "https"});
    }

    @Override
    public InputStream resolve(String url) throws ResourceRetrievalException {
        try {
            Exchange exc = new Request.Builder().method("GET").url(this.uriFactory, url).header("User-Agent", "Membrane Service Proxy " + Constants.VERSION).buildExchange();
            Response response = this.getHttpClient().call(exc).getResponse();
            response.readBody();
            if (response.getStatusCode() != 200) {
                ResourceRetrievalException rde = new ResourceRetrievalException(url, response.getStatusCode());
                throw rde;
            }
            return new ByteArrayInputStream(ByteUtil.getByteArrayData(response.getBodyAsStreamDecoded()));
        }
        catch (ResourceRetrievalException e) {
            throw e;
        }
        catch (Exception e) {
            ResourceRetrievalException rre = new ResourceRetrievalException(url, e);
            throw rre;
        }
    }

    @Override
    public void observeChange(String url, Consumer<InputStream> consumer) throws ResourceRetrievalException {
        this.watchedUrlMd5s.put(url, "");
        this.consumerForUrls.put(url, consumer);
        if (this.httpWatcher == null) {
            this.httpWatcher = new Thread(this.httpWatchJob);
        }
        if (!this.httpWatcher.isAlive()) {
            this.httpWatcher.start();
        }
    }

    @Override
    public List<String> getChildren(String url) {
        return null;
    }

    @Override
    public long getTimestamp(String url) {
        return 0L;
    }

    public synchronized HttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public synchronized void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
        this.httpClient = null;
    }
}

