/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.core.rules.RuleKey;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleKey
implements RuleKey {
    private static Logger log = LoggerFactory.getLogger((String)AbstractRuleKey.class.getName());
    protected int port;
    private String path;
    protected volatile Pattern pathPattern;
    protected boolean pathRegExp = true;
    protected boolean usePathPattern;
    protected String ip;

    public AbstractRuleKey(int port, String ip) {
        this.port = port;
        this.ip = ip;
    }

    @Override
    public String getHost() {
        return "";
    }

    @Override
    public String getMethod() {
        return "";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean isHostWildcard() {
        return false;
    }

    @Override
    public boolean isMethodWildcard() {
        return false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public boolean isPathRegExp() {
        return this.pathRegExp;
    }

    @Override
    public void setPathRegExp(boolean pathRegExp) {
        this.pathRegExp = pathRegExp;
    }

    @Override
    public boolean isUsePathPattern() {
        return this.usePathPattern;
    }

    @Override
    public void setUsePathPattern(boolean usePathPattern) {
        this.usePathPattern = usePathPattern;
        this.pathPattern = null;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
        this.pathPattern = null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean matchesPath(String path) {
        if (this.isPathRegExp()) {
            return this.matchesPathPattern(path);
        }
        return path.startsWith(this.getPath());
    }

    private boolean matchesPathPattern(String path) {
        log.debug("matches path: " + path + " with path pattern: " + this.getPathPattern());
        return this.getPathPattern().matcher(path).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getPathPattern() {
        Pattern p = this.pathPattern;
        if (p == null) {
            AbstractRuleKey abstractRuleKey = this;
            synchronized (abstractRuleKey) {
                if (this.pathPattern == null) {
                    p = this.pathPattern = Pattern.compile(this.path);
                }
            }
        }
        return p;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public boolean matchesHostHeader(String hostHeader) {
        return false;
    }

    @Override
    public boolean matchesVersion(String version) {
        return !"STOMP".equals(version);
    }

    @Override
    public boolean complexMatch(String hostHeader, String method, String uri, String version, int port, String localIP) {
        return true;
    }
}

